/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.Collections;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;
public class CreateIssue extends AbstractHandler {

    private static Resource getResource(ISelection sel) {
        Resource r = AdaptionUtils.adaptToSingle(sel, Resource.class);
        return r;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
    	
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        final Resource element = getResource(sel);
        if (element == null)
            return null;

        SimanticsUI.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
            	
                IssueResource ISSUE = IssueResource.getInstance(graph);
				
                Resource resource = graph.getPossibleObject(element, ModelingResources.getInstance(graph).ElementToComponent);
                if(resource == null) return;
                
				IssueUtils.newUserIssueForModel(graph, resource, "New User Issue", ISSUE.Severity_Note, Collections.singletonList(resource));
            	
            }
        });

        return null;
    }

}

