package org.simantics.modeling.ui.diagram;

import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class SetFocusabilityContribution extends DynamicMenuContribution implements IExecutableExtension {

    String          name    = "";
    ImageDescriptor image   = null;
    boolean         allow = true;

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data)
            throws CoreException {
        if (data instanceof Map<?,?>) {
            @SuppressWarnings("unchecked")
            Map<String, String> args = (Map<String, String>) data;
            name = args.get("name");
            String imageId = args.get("image");
            image = Activator.getDefault().getImageRegistry().getDescriptor(imageId);
            allow = Boolean.parseBoolean(args.get("allow"));
        }
    }

    @Override
    protected Object[] getSelectedObjects() {
        IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
        if (editorPart == null)
            return NO_OBJECTS;
        if(editorPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor) editorPart;
            IDiagram diagram = (IDiagram) editor.getAdapter(IDiagram.class);
            if (diagram == null)
                return NO_OBJECTS;
            ILayersEditor le = diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
            if (le == null)
                return NO_OBJECTS;
            return new Object[] { le, le.getIgnoreFocusSettings() };
        }
        return NO_OBJECTS;
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] elements) throws DatabaseException {
        if (elements == NO_OBJECTS)
            return NONE;

        final ILayersEditor le = (ILayersEditor) elements[0];
        final Boolean value = (Boolean) elements[1];

        if (allow == value)
            return NONE;

        return new IContributionItem[] {
                new ActionContributionItem(new Action(name, image) {
                    @Override
                    public void run() {
                        ThreadUtils.asyncExec(AWTThread.getThreadAccess(), new Runnable() {
                            @Override
                            public void run() {
                                le.setIgnoreFocusSettings(!value);
                            }
                        });
                    }
                })
        };
    }

}
