/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.scl.ui.editor.SCLTextEditorNew;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class SCLModuleViewer {

    ResourceManager resourceManager;

    Resource componentType;
    
    SCLTextEditorNew code;

    Form form;
    FormToolkit tk;

    public SCLModuleViewer(Composite parent, Resource _componentType, String formTitle) {
        this.componentType = _componentType;

        tk = new FormToolkit(parent.getDisplay());
        form = tk.createForm(parent);
        tk.decorateFormHeading(form);

        resourceManager = new LocalResourceManager(JFaceResources.getResources(), form);
        form.setText(formTitle);
        form.setImage(resourceManager.createImage(Activator.COMPONENT_TYPE_ICON));

        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(form.getBody());

        // Table

        Section codeSection = tk.createSection(form.getBody(), Section.TITLE_BAR | Section.EXPANDED);
        codeSection.setLayout(new FillLayout());
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.FILL).grab(true, true).applyTo(codeSection);
        codeSection.setText("Code");
        
        Composite codeSectionBody = tk.createComposite(codeSection);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(codeSectionBody);
        codeSection.setClient(codeSectionBody);

        Composite codeButtons = tk.createComposite(codeSectionBody);
        GridDataFactory.fillDefaults().applyTo(codeButtons);
        GridLayoutFactory.fillDefaults().applyTo(codeButtons);

        Button applyChanges = tk.createButton(codeButtons, "Apply changes", SWT.PUSH);

        code = new SCLTextEditorNew(codeSectionBody, 0);
        
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.FILL).grab(true, true).applyTo(code);
        

        GridDataFactory.fillDefaults().applyTo(applyChanges);

        applyChanges.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {

                final String text = code.getContent(); 
                
                Simantics.getSession().async(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph)
                            throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance(graph);
                        graph.claimLiteral(componentType, L0.SCLModule_definition, text, Bindings.STRING);
                    }
                });
                
            }
        });
        
//        Section section = tk.createSection(form.getBody(), Section.TITLE_BAR | Section.EXPANDED);
//        section.setLayout(new FillLayout());
//        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.FILL).grab(true, true).applyTo(section);
//        section.setText("Problems");
        
        Simantics.getSession().asyncRequest(new ResourceRead<String>(componentType) {
            @Override
            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance(graph);
                return graph.getPossibleRelatedValue(resource, L0.SCLModule_definition, Bindings.STRING);
            }
        }, new Listener<String>() {
            @Override
            public void execute(final String text) {
                SWTUtils.asyncExec(code, new Runnable() {
                    @Override
                    public void run() {
                        
                        if (code.isDisposed())
                            return;
                        
                        code.setContent(text, null);
                        
                    }
                });
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(t);
            }

            @Override
            public boolean isDisposed() {
                return code.isDisposed();
            }

        });        

        // Disposing

        code.addDisposeListener(new DisposeListener() {
            @Override
            public void widgetDisposed(DisposeEvent e) {
                tk.dispose();
            }
        });

    }

    protected Datatype getPossibleDatatype(ReadGraph graph, Resource literal) throws DatabaseException {
        Binding binding = Bindings.getBindingUnchecked(Datatype.class);
        for (Resource dataTypeResource : graph.getObjects(literal, Layer0.getInstance(graph).HasDataType)) {
            Datatype dt = graph.getPossibleValue(dataTypeResource, binding);
            if (dt != null)
                return dt;
        }
        return null;
    }

    public void setFocus() {
        if(code != null && !code.isDisposed())
            code.setFocus();
    }

}
