package org.simantics.modeling.ui.componentTypeEditor;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.Resource;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.StringUtils;

public class ComponentTypeViewerPropertyInfo implements Comparable<ComponentTypeViewerPropertyInfo> {
    public Resource resource;
    public String name;
    public String type;
    public String defaultValue;
    public String label;
    public String description;
    @Optional
    public String expression;
    @Optional
    public String valid;
    @Optional
    public NumberType numberType;
    @Optional
    public String unit;
    public boolean immutable;
    public Object sectionSpecificData; 

    public ComponentTypeViewerPropertyInfo(Resource resource, String name, String type, String defaultValue, NumberType numberType, String unit, String label, String description, String expression, String valid, boolean immutable) {
        this.resource = resource;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.numberType = numberType;
        this.unit = unit;
        this.label = label;
        this.description = description;
        this.expression = expression;
        this.valid = valid;
        this.immutable = immutable;
    }

    @Override
    public int compareTo(ComponentTypeViewerPropertyInfo o) {
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(name, (o.name));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((defaultValue == null) ? 0 : defaultValue.hashCode());
        result = prime * result
                + ((description == null) ? 0 : description.hashCode());
        result = prime * result
                + ((expression == null) ? 0 : expression.hashCode());
        result = prime * result + (immutable ? 1231 : 1237);
        result = prime * result + ((label == null) ? 0 : label.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result
                + ((numberType == null) ? 0 : numberType.hashCode());
        result = prime * result
                + ((resource == null) ? 0 : resource.hashCode());
        result = prime * result + ((sectionSpecificData == null) ? 0
                : sectionSpecificData.hashCode());
        result = prime * result + ((type == null) ? 0 : type.hashCode());
        result = prime * result + ((unit == null) ? 0 : unit.hashCode());
        result = prime * result + ((valid == null) ? 0 : valid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ComponentTypeViewerPropertyInfo other = (ComponentTypeViewerPropertyInfo) obj;
        if (defaultValue == null) {
            if (other.defaultValue != null)
                return false;
        } else if (!defaultValue.equals(other.defaultValue))
            return false;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (expression == null) {
            if (other.expression != null)
                return false;
        } else if (!expression.equals(other.expression))
            return false;
        if (immutable != other.immutable)
            return false;
        if (label == null) {
            if (other.label != null)
                return false;
        } else if (!label.equals(other.label))
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (numberType == null) {
            if (other.numberType != null)
                return false;
        } else if (!numberType.equals(other.numberType))
            return false;
        if (resource == null) {
            if (other.resource != null)
                return false;
        } else if (!resource.equals(other.resource))
            return false;
        if (sectionSpecificData == null) {
            if (other.sectionSpecificData != null)
                return false;
        } else if (!sectionSpecificData.equals(other.sectionSpecificData))
            return false;
        if (type == null) {
            if (other.type != null)
                return false;
        } else if (!type.equals(other.type))
            return false;
        if (unit == null) {
            if (other.unit != null)
                return false;
        } else if (!unit.equals(other.unit))
            return false;
        if (valid == null) {
            if (other.valid != null)
                return false;
        } else if (!valid.equals(other.valid))
            return false;
        return true;
    }

    public String unitString() {
        String result = numberType == null ? null : numberType.getUnit();
        if (result == null)
            result = unit;
        return StringUtils.safeString(result);
    }

    public String rangeString() {
        return StringUtils.safeString(numberType == null ? null : numberType.getRangeStr());
    }

}