package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;

public class NewLibrary implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;
        return new Runnable() {
            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        createLibrary(graph, parent);
                    }
                });
            }
        };
    }

    public static Resource createLibrary(WriteGraph graph, Resource parent) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 l0 = Layer0.getInstance(graph);

        Resource library = graph.newResource();
        String name = NameUtils.findFreshName(graph, "Library", parent, l0.ConsistsOf);
        graph.claim(library, l0.InstanceOf, null, l0.Library);
        graph.addLiteral(library, l0.HasName, l0.NameOf, l0.String, name, Bindings.STRING);
        graph.claim(library, l0.PartOf, parent);

        Layer0Utils.addCommentMetadata(graph, "Created new Library named " + name + ", resource " + library);

        return library;
    }
    
    public Resource newLibrary(final Resource parent) throws DatabaseException {
    	Resource library = Simantics.getSession().syncRequest(new WriteResultRequest<Resource>() {

			@Override
			public Resource perform(WriteGraph graph) throws DatabaseException {
				Resource library = createLibrary(graph, parent);
				return library;
			}
		});
    	return library;
    }
}
