package org.simantics.modeling.ui.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;

public class NewConnectionPoint implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;
        final Resource componentType = (Resource)target;
        return new Runnable() {
            @Override
            public void run() {
                try {
                    
                    Map<Resource, Pair<String, ImageDescriptor>> map = Simantics.sync(new UniqueRead<Map<Resource,Pair<String,ImageDescriptor>>>() {

                        @Override
                        public Map<Resource, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                            
                            HashMap<Resource, Pair<String,ImageDescriptor>> map = new HashMap<Resource, Pair<String,ImageDescriptor>>(); 
                            
                            Layer0 L0 = Layer0.getInstance(graph);
                            
                            StructuralResource2 STR = StructuralResource2.getInstance(graph);
                            ModelingResources MOD = ModelingResources.getInstance(graph);
                            
                            Instances query = graph.adapt(STR.ConnectionRelation, Instances.class);
                            
                            Resource model = graph.sync(new PossibleIndexRoot(componentType));
                            
//                            List<String> domainNames = new ArrayList<String>();
                            
                            for(Resource _res : query.find(graph, model)) {

                                boolean isDiagramRelation = graph.hasStatement(_res, MOD.DiagramConnectionRelationToConnectionRelation);
                                if (isDiagramRelation)
                                    continue;

                                Collection<Resource> domains = graph.getObjects(_res, L0.HasDomain);
                                
                                String name = null;
                                if(domains.size() == 0) {
                                    continue;
                                } else if (domains.size() > 1) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append(NameUtils.getSafeName(graph, _res));
//                                    domainNames.clear();
//                                    for (Resource domain : domains)
//                                        domainNames.add(NameUtils.getSafeName(graph, domain));
//                                    Collections.sort(domainNames, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
//                                    String prefix = findLongestCommonPrefix(domainNames);
//                                    sb.append(" - ").append(prefix).append("{");
//                                    boolean first = true;
//                                    for (String s : domainNames) {
//                                        if (!first)
//                                            sb.append(",");
//                                        first = false;
//                                        sb.append(s.substring(prefix.length()));
//                                    }
//                                    sb.append("}");
                                    name = sb.toString();
                                } else {
                                    // domains.size() == 1
                                    name = NameUtils.getSafeName(graph, _res) + " (" + graph.getURI(domains.iterator().next()) + ")";
                                }
                                map.put(_res, new Pair<String, ImageDescriptor>(name, null));
                                
                            }
                            
                            return map;
                            
                        }

                    });
                    
                    final Resource[] cps = queryCps(map);
                    if(cps.length == 0) return;
                    
                    Simantics.getSession().async(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            for (Resource cp : cps)
                                ComponentTypeCommands.createConnectionPoint(graph, componentType, cp);
                            Layer0Utils.addCommentMetadata(graph, createConnectionPointComment(graph, componentType, cps));
                        }
                        String createConnectionPointComment(ReadGraph graph, Resource target, Resource[] cps) throws DatabaseException {
                            StringBuilder result = new StringBuilder();
                            result.append("Created connection point");
                            if (cps.length > 1)
                                result.append('s');
                            result.append(" for ")
                            .append(NameUtils.getSafeName(graph, componentType))
                            .append(":\n");
                            for (int i = 0; i < cps.length; ++i) {
                                result.append('\t');
                                result.append(NameUtils.getSafeName(graph, cps[i]));
                                result.append('\n');
                            }
                            return result.toString();
                        }
                    });
                    
                } catch (DatabaseException e1) {
                    ErrorLogger.defaultLogError(e1);
                }
            }
        };
    }

//    private static String findLongestCommonPrefix(List<String> strs) {
//        int count = strs.size();
//        if (count == 0)
//            return "";
//        if (count == 1)
//            return strs.get(0);
//        int maxLen = Integer.MAX_VALUE;
//        for (int n = 0; n < count; ++n)
//            maxLen = Math.min(maxLen, strs.get(n).length());
//        int i = 0;
//        chars:
//            for (; i < maxLen; ++i) {
//                char ch = strs.get(0).charAt(i);
//                for (int n = 1; n < count; ++n) {
//                    if (strs.get(n).charAt(i) != ch)
//                        break chars;
//                }
//            }
//        return strs.get(0).substring(0, Math.max(0, i));
//    }

    private Resource[] queryCps(Map<Resource, Pair<String, ImageDescriptor>> map) {

        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ResourceSelectionDialog3<Resource> dialog = new ResourceSelectionDialog3<Resource>(shell, map, "Select connection point type") {
            @Override
            protected IDialogSettings getBaseDialogSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        if (dialog.open() == Window.OK) {
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                final Resource[] res = new Resource[result.length];
                System.arraycopy(result, 0, res, 0, result.length);
                return res;
            }
        }
        return Resource.NONE;
        
    }
}
