package org.simantics.modeling.tests.commands;

import java.util.Set;

import junit.framework.Assert;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.issues.common.AllModelIssues;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleModelTrait;

public class AssertModelIssueCount extends WriteCommand<ModelingCommandSequenceTest> {

	private SingleModelTrait model;
	private int expected;
	
	public AssertModelIssueCount(SingleModelTrait model, int expected) {
		this.model = model;
		this.expected = expected;
	}
	
	@Override
	protected void run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
		
		Set<Resource> issues = graph.sync(new AllModelIssues(model.getResource()));
		Assert.assertEquals(expected, issues.size());
        
	}

}