package org.simantics.modeling.svg;

import java.io.File;
import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.utils.FileUtils;

public class CreateSVGElement {

    public static void createSVGElement(WriteGraph g, Resource diagram, String suffix, byte[] data, double mposX, double mposY) throws DatabaseException {
        createSVGElement(g, diagram, suffix, data, mposX, mposY);
    }

    public static Resource createSVGElementR(WriteGraph g, Resource diagram, String suffix, byte[] data, double mposX, double mposY) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);
        ImageResource IMAGE = ImageResource.getInstance(g);
        G2DResource G2D = G2DResource.getInstance(g);

        Resource element;
        if("svg".equals(suffix)) {
            Resource transform = GraphUtils.create(g, L0.InstanceOf, G2D.Transform);
            g.claimValue(transform, new double[] {1.0, 0.0, 0.0, 1.0, mposX, mposY}, Bindings.DOUBLE_ARRAY);
            element = GraphUtils.create(g,
                    L0.InstanceOf, DIA.SVGElement,
                    G2D.HasSVGDocument, new String(data),
                    DIA.HasTransform, transform);
            AddElement.claimFreshElementName(g, diagram, element);
        } else if ("png".equals(suffix)) {
            Resource transform = GraphUtils.create(g, L0.InstanceOf, G2D.Transform);
            g.claimValue(transform, new double[] {1.0, 0.0, 0.0, 1.0, mposX, mposY}, Bindings.DOUBLE_ARRAY);
            Resource image = g.newResource();
            g.claim(image, L0.InstanceOf, IMAGE.PngImage);
            g.claimValue(image, data, Bindings.BYTE_ARRAY);
            element = GraphUtils.create(g,
                    L0.InstanceOf, DIA.RasterElement,
                    G2D.HasRasterImage, image,
                    DIA.HasTransform, transform);
            AddElement.claimFreshElementName(g, diagram, element);
        }
        else
            throw new DatabaseException("Unknown image format " + suffix);
        OrderedSetUtils.addFirst(g, diagram, element);
        g.claim(diagram, L0.ConsistsOf, element);
        return element;
    }

    public static void importSVGElement(WriteGraph graph, Resource diagram, File file, double posX, double posY) throws DatabaseException, IOException {
        importSVGElementR(graph, diagram, file, posX, posY);
    }

    public static Resource importSVGElementR(WriteGraph graph, Resource diagram, File file, double posX, double posY) throws DatabaseException, IOException {
        final byte[] data = FileUtils.readFile(file);
        return createSVGElementR(graph, diagram, suffix(file.getName()), data, posX, posY);
    }

    private static String suffix(String fileName) {
        int len = fileName.length();
        if(len < 3) return null;
        else return fileName.substring(len-3,len).toLowerCase();
    }

}
