package org.simantics.modeling.scl.ontologymodule;


import java.util.Collection;
import java.util.Collections;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Success;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gnu.trove.procedure.TObjectProcedure;

public enum OntologyModuleSourceRepository implements ModuleSourceRepository {
    INSTANCE;
    
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyModuleSourceRepository.class);

	static class ModuleRequest extends UnaryRead<String, Module> {

        public ModuleRequest(String moduleName) {
			super(moduleName);
		}

		@Override
        public Module perform(ReadGraph graph) throws DatabaseException {
            return new OntologyModule(graph, parameter);
        }

    };
	
    @Override
    public ModuleSource getModuleSource(final String moduleName,
            UpdateListener listener) {
        if(!moduleName.startsWith("http://"))
            return null; // Don't do a graph request if this cannot be a resource
        
        return new ModuleSource() {

            @Override
            public double getPriority() {
                return -1.0;
            }

            @Override
            public String getModuleName() {
                return moduleName;
            }

            @Override
            public ClassLoader getClassLoader() {
                return getClass().getClassLoader();
            }

            @Override
            public Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener,
                    ModuleCompilationOptions options) {
                try {
                    return new Success<Module>(Simantics.getAvailableRequestProcessor().syncRequest(new ModuleRequest(moduleName)));
                } catch(DatabaseException e) {
                    return new Failure(e);
                }
            }
        };
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
    }
    
    @Override
    public Collection<String> getModuleNames() {
        return Collections.emptyList();
    }

}
