package org.simantics.modeling;

import java.util.HashSet;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class LifeCycleProcesses extends AbstractProjectFeature {
	
	Set<LifeCycleContext> contexts = new HashSet<LifeCycleContext>();

	@Override
	public void configure() throws ProjectException {

		try {

			Simantics.getSession().syncRequest(new ReadRequest() {

				@Override
				public void run(ReadGraph graph) throws DatabaseException {

					ModelingResources MOD = ModelingResources.getInstance(graph);
					for(Resource indexRoot : Layer0Utils.listIndexRoots(graph)) {
						for(Resource lcp : ModelingUtils.searchByTypeShallow(graph, indexRoot, MOD.LifeCycleProcess)) {
							
//							System.err.println("Loading life cycle process " + graph.getURI(lcp));
							Function1<LifeCycleContext,Tuple0> load = null; 
							Function1<LifeCycleContext,Tuple0> unload = null;
					    	Variable loadProperty = Variables.tryGetProperty(graph, lcp, MOD.LifeCycleProcess_load);
					    	if (loadProperty != null) {
					            load = loadProperty.getPossibleValue(graph);
					    	}
					    	Variable unloadProperty = Variables.tryGetProperty(graph, lcp, MOD.LifeCycleProcess_unload);
					    	if (unloadProperty != null) {
					            unload = unloadProperty.getPossibleValue(graph);
					    	}

							LifeCycleContext lcc = new LifeCycleContext(lcp, load, unload);
							contexts.add(lcc);
							
						}
					}
					
				}
				
			});
			
		} catch (DatabaseException e) {
			
			throw new ProjectException(e);
			
		}
		
		for(LifeCycleContext context : contexts) {
			context.load();
		}
		
	}

	@Override
	public void deconfigure() throws ProjectException {

		for(LifeCycleContext context : contexts) {
			context.unload();
		}

	}
   	
}
