package org.simantics.modeling;

import java.util.List;
import java.util.Set;

import org.simantics.scl.compiler.errors.CompilationError;

public class ComponentTypeScriptResult {

    private List<CompilationError> errors;
    private Object value;

    private Set<String> moduleReads;
    private Set<String> moduleWrites;
    
    public ComponentTypeScriptResult(List<CompilationError> errors, Object value) {
        this(errors, value, null, null);
    }
    
    public ComponentTypeScriptResult(List<CompilationError> errors, Object value, Set<String> moduleReads, Set<String> moduleWrites) {
        this.errors = errors;
        this.value = value;
        this.moduleReads = moduleReads;
        this.moduleWrites = moduleWrites;
    }
    
    public List<CompilationError> getErrors() {
        return errors;
    }
    
    public Object getValue() {
        return value;
    }
    
    public Set<String> getModuleReads() {
        return moduleReads;
    }
    
    public Set<String> getModuleWrites() {
        return moduleWrites;
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((errors == null) ? 0 : errors.hashCode());
        result = prime * result
                + ((moduleReads == null) ? 0 : moduleReads.hashCode());
        result = prime * result
                + ((moduleWrites == null) ? 0 : moduleWrites.hashCode());
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ComponentTypeScriptResult other = (ComponentTypeScriptResult) obj;
        if (errors == null) {
            if (other.errors != null)
                return false;
        } else if (!errors.equals(other.errors))
            return false;
        if (moduleReads == null) {
            if (other.moduleReads != null)
                return false;
        } else if (!moduleReads.equals(other.moduleReads))
            return false;
        if (moduleWrites == null) {
            if (other.moduleWrites != null)
                return false;
        } else if (!moduleWrites.equals(other.moduleWrites))
            return false;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

}
