package org.simantics.migration.ui;

import java.util.ArrayList;
import java.util.Collections;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.SoftwareConfigurationResources;
import org.simantics.migration.ui.MigrationAnalysis.Update;

public class MigrateActionFactory implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        final Resource resource = (Resource)target;
        return new Runnable() {
            @Override
            public void run() {
                analyze(resource);
            }            
        };
    }
    
    private void analyze(final Resource resource) {
        Simantics.getSession().asyncRequest(new ReadRequest() {            
            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SoftwareConfigurationResources SC = SoftwareConfigurationResources.getInstance(graph);
                final ArrayList<Update> updates = new ArrayList<Update>();
                for(Resource version : graph.getObjects(resource, SC.IsCompatibleWith)) {
                    MigrationAnalysis analysis = new MigrationAnalysis(graph, version);
                    updates.addAll(analysis.getUpdates());
                }
                Collections.sort(updates);
                Display.getDefault().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                        select(resource, updates);                        
                    }            
                });  
            }
        });
    }
    
    private void select(final Resource resource, final ArrayList<Update> updates) {
        ListDialog listDialog = new ListDialog(Display.getCurrent().getActiveShell());
        listDialog.setTitle("Migrate");
        listDialog.setMessage("Choose the version to migrate to");
        listDialog.setContentProvider(new IStructuredContentProvider() {            
            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {       
            }
            
            @Override
            public void dispose() {
            }
            
            @Override
            public Object[] getElements(Object inputElement) {
                return updates.toArray();
            }
        });
        listDialog.setLabelProvider(new LabelProvider() {
            @Override
            public String getText(Object element) {
                return ((Update)element).versionName;
            }
        });
        listDialog.setInput(updates);
        if(listDialog.open() == ListDialog.OK) {
            Object[] result = listDialog.getResult();
            if(result.length == 1) {
                Update update = (Update)result[0];
                try {
                    update.execute(resource);
                    update.updateTargetVersion(resource);                    
                } catch(DatabaseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

}
