/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.forms.widgets.FormText;

public class TextColors {

    static class Mapping {
        String name;
        RGB    rgb;
        Mapping(String name, RGB rgb) {
            this.name = name;
            this.rgb = rgb;
        }
    }

    static Mapping[] colors = new Mapping[] {
        new Mapping("AliceBlue", new RGB(0xF0, 0xF8, 0xFF)),
        new Mapping("AntiqueWhite", new RGB(0xFA, 0xEB, 0xD7)), new Mapping("Aqua", new RGB(0x00, 0xFF, 0xFF)),
        new Mapping("Aquamarine", new RGB(0x7F, 0xFF, 0xD4)), new Mapping("Azure", new RGB(0xF0, 0xFF, 0xFF)),
        new Mapping("Beige", new RGB(0xF5, 0xF5, 0xDC)), new Mapping("Bisque", new RGB(0xFF, 0xE4, 0xC4)),
        new Mapping("Black", new RGB(0x00, 0x00, 0x00)), new Mapping("BlanchedAlmond", new RGB(0xFF, 0xEB, 0xCD)),
        new Mapping("Blue", new RGB(0x00, 0x00, 0xFF)), new Mapping("BlueViolet", new RGB(0x8A, 0x2B, 0xE2)),
        new Mapping("Brown", new RGB(0xA5, 0x2A, 0x2A)), new Mapping("BurlyWood", new RGB(0xDE, 0xB8, 0x87)),
        new Mapping("CadetBlue", new RGB(0x5F, 0x9E, 0xA0)), new Mapping("Chartreuse", new RGB(0x7F, 0xFF, 0x00)),
        new Mapping("Chocolate", new RGB(0xD2, 0x69, 0x1E)), new Mapping("Coral", new RGB(0xFF, 0x7F, 0x50)),
        new Mapping("CornflowerBlue", new RGB(0x64, 0x95, 0xED)),
        new Mapping("Cornsilk", new RGB(0xFF, 0xF8, 0xDC)), new Mapping("Crimson", new RGB(0xDC, 0x14, 0x3C)),
        new Mapping("Cyan", new RGB(0x00, 0xFF, 0xFF)), new Mapping("DarkBlue", new RGB(0x00, 0x00, 0x8B)),
        new Mapping("DarkCyan", new RGB(0x00, 0x8B, 0x8B)),
        new Mapping("DarkGoldenRod", new RGB(0xB8, 0x86, 0x0B)),
        new Mapping("DarkGray", new RGB(0xA9, 0xA9, 0xA9)), new Mapping("DarkGreen", new RGB(0x00, 0x64, 0x00)),
        new Mapping("DarkKhaki", new RGB(0xBD, 0xB7, 0x6B)), new Mapping("DarkMagenta", new RGB(0x8B, 0x00, 0x8B)),
        new Mapping("DarkOliveGreen", new RGB(0x55, 0x6B, 0x2F)),
        new Mapping("Darkorange", new RGB(0xFF, 0x8C, 0x00)), new Mapping("DarkOrchid", new RGB(0x99, 0x32, 0xCC)),
        new Mapping("DarkRed", new RGB(0x8B, 0x00, 0x00)), new Mapping("DarkSalmon", new RGB(0xE9, 0x96, 0x7A)),
        new Mapping("DarkSeaGreen", new RGB(0x8F, 0xBC, 0x8F)),
        new Mapping("DarkSlateBlue", new RGB(0x48, 0x3D, 0x8B)),
        new Mapping("DarkSlateGray", new RGB(0x2F, 0x4F, 0x4F)),
        new Mapping("DarkTurquoise", new RGB(0x00, 0xCE, 0xD1)),
        new Mapping("DarkViolet", new RGB(0x94, 0x00, 0xD3)), new Mapping("DeepPink", new RGB(0xFF, 0x14, 0x93)),
        new Mapping("DeepSkyBlue", new RGB(0x00, 0xBF, 0xFF)), new Mapping("DimGray", new RGB(0x69, 0x69, 0x69)),
        new Mapping("DodgerBlue", new RGB(0x1E, 0x90, 0xFF)), new Mapping("FireBrick", new RGB(0xB2, 0x22, 0x22)),
        new Mapping("FloralWhite", new RGB(0xFF, 0xFA, 0xF0)),
        new Mapping("ForestGreen", new RGB(0x22, 0x8B, 0x22)), new Mapping("Fuchsia", new RGB(0xFF, 0x00, 0xFF)),
        new Mapping("Gainsboro", new RGB(0xDC, 0xDC, 0xDC)), new Mapping("GhostWhite", new RGB(0xF8, 0xF8, 0xFF)),
        new Mapping("Gold", new RGB(0xFF, 0xD7, 0x00)), new Mapping("GoldenRod", new RGB(0xDA, 0xA5, 0x20)),
        new Mapping("Gray", new RGB(0x80, 0x80, 0x80)), new Mapping("Green", new RGB(0x00, 0x80, 0x00)),
        new Mapping("GreenYellow", new RGB(0xAD, 0xFF, 0x2F)), new Mapping("HoneyDew", new RGB(0xF0, 0xFF, 0xF0)),
        new Mapping("HotPink", new RGB(0xFF, 0x69, 0xB4)), new Mapping("IndianRed", new RGB(0xCD, 0x5C, 0x5C)),
        new Mapping("Indigo", new RGB(0x4B, 0x00, 0x82)), new Mapping("Ivory", new RGB(0xFF, 0xFF, 0xF0)),
        new Mapping("Khaki", new RGB(0xF0, 0xE6, 0x8C)), new Mapping("Lavender", new RGB(0xE6, 0xE6, 0xFA)),
        new Mapping("LavenderBlush", new RGB(0xFF, 0xF0, 0xF5)),
        new Mapping("LawnGreen", new RGB(0x7C, 0xFC, 0x00)),
        new Mapping("LemonChiffon", new RGB(0xFF, 0xFA, 0xCD)),
        new Mapping("LightBlue", new RGB(0xAD, 0xD8, 0xE6)), new Mapping("LightCoral", new RGB(0xF0, 0x80, 0x80)),
        new Mapping("LightCyan", new RGB(0xE0, 0xFF, 0xFF)),
        new Mapping("LightGoldenRodYellow", new RGB(0xFA, 0xFA, 0xD2)),
        new Mapping("LightGrey", new RGB(0xD3, 0xD3, 0xD3)), new Mapping("LightGreen", new RGB(0x90, 0xEE, 0x90)),
        new Mapping("LightPink", new RGB(0xFF, 0xB6, 0xC1)), new Mapping("LightSalmon", new RGB(0xFF, 0xA0, 0x7A)),
        new Mapping("LightSeaGreen", new RGB(0x20, 0xB2, 0xAA)),
        new Mapping("LightSkyBlue", new RGB(0x87, 0xCE, 0xFA)),
        new Mapping("LightSlateGray", new RGB(0x77, 0x88, 0x99)),
        new Mapping("LightSteelBlue", new RGB(0xB0, 0xC4, 0xDE)),
        new Mapping("LightYellow", new RGB(0xFF, 0xFF, 0xE0)), new Mapping("Lime", new RGB(0x00, 0xFF, 0x00)),
        new Mapping("LimeGreen", new RGB(0x32, 0xCD, 0x32)), new Mapping("Linen", new RGB(0xFA, 0xF0, 0xE6)),
        new Mapping("Magenta", new RGB(0xFF, 0x00, 0xFF)), new Mapping("Maroon", new RGB(0x80, 0x00, 0x00)),
        new Mapping("MediumAquaMarine", new RGB(0x66, 0xCD, 0xAA)),
        new Mapping("MediumBlue", new RGB(0x00, 0x00, 0xCD)),
        new Mapping("MediumOrchid", new RGB(0xBA, 0x55, 0xD3)),
        new Mapping("MediumPurple", new RGB(0x93, 0x70, 0xD8)),
        new Mapping("MediumSeaGreen", new RGB(0x3C, 0xB3, 0x71)),
        new Mapping("MediumSlateBlue", new RGB(0x7B, 0x68, 0xEE)),
        new Mapping("MediumSpringGreen", new RGB(0x00, 0xFA, 0x9A)),
        new Mapping("MediumTurquoise", new RGB(0x48, 0xD1, 0xCC)),
        new Mapping("MediumVioletRed", new RGB(0xC7, 0x15, 0x85)),
        new Mapping("MidnightBlue", new RGB(0x19, 0x19, 0x70)),
        new Mapping("MintCream", new RGB(0xF5, 0xFF, 0xFA)), new Mapping("MistyRose", new RGB(0xFF, 0xE4, 0xE1)),
        new Mapping("Moccasin", new RGB(0xFF, 0xE4, 0xB5)), new Mapping("NavajoWhite", new RGB(0xFF, 0xDE, 0xAD)),
        new Mapping("Navy", new RGB(0x00, 0x00, 0x80)), new Mapping("OldLace", new RGB(0xFD, 0xF5, 0xE6)),
        new Mapping("Olive", new RGB(0x80, 0x80, 0x00)), new Mapping("OliveDrab", new RGB(0x6B, 0x8E, 0x23)),
        new Mapping("Orange", new RGB(0xFF, 0xA5, 0x00)), new Mapping("OrangeRed", new RGB(0xFF, 0x45, 0x00)),
        new Mapping("Orchid", new RGB(0xDA, 0x70, 0xD6)), new Mapping("PaleGoldenRod", new RGB(0xEE, 0xE8, 0xAA)),
        new Mapping("PaleGreen", new RGB(0x98, 0xFB, 0x98)),
        new Mapping("PaleTurquoise", new RGB(0xAF, 0xEE, 0xEE)),
        new Mapping("PaleVioletRed", new RGB(0xD8, 0x70, 0x93)),
        new Mapping("PapayaWhip", new RGB(0xFF, 0xEF, 0xD5)), new Mapping("PeachPuff", new RGB(0xFF, 0xDA, 0xB9)),
        new Mapping("Peru", new RGB(0xCD, 0x85, 0x3F)), new Mapping("Pink", new RGB(0xFF, 0xC0, 0xCB)),
        new Mapping("Plum", new RGB(0xDD, 0xA0, 0xDD)), new Mapping("PowderBlue", new RGB(0xB0, 0xE0, 0xE6)),
        new Mapping("Purple", new RGB(0x80, 0x00, 0x80)), new Mapping("Red", new RGB(0xFF, 0x00, 0x00)),
        new Mapping("RosyBrown", new RGB(0xBC, 0x8F, 0x8F)), new Mapping("RoyalBlue", new RGB(0x41, 0x69, 0xE1)),
        new Mapping("SaddleBrown", new RGB(0x8B, 0x45, 0x13)), new Mapping("Salmon", new RGB(0xFA, 0x80, 0x72)),
        new Mapping("SandyBrown", new RGB(0xF4, 0xA4, 0x60)), new Mapping("SeaGreen", new RGB(0x2E, 0x8B, 0x57)),
        new Mapping("SeaShell", new RGB(0xFF, 0xF5, 0xEE)), new Mapping("Sienna", new RGB(0xA0, 0x52, 0x2D)),
        new Mapping("Silver", new RGB(0xC0, 0xC0, 0xC0)), new Mapping("SkyBlue", new RGB(0x87, 0xCE, 0xEB)),
        new Mapping("SlateBlue", new RGB(0x6A, 0x5A, 0xCD)), new Mapping("SlateGray", new RGB(0x70, 0x80, 0x90)),
        new Mapping("Snow", new RGB(0xFF, 0xFA, 0xFA)), new Mapping("SpringGreen", new RGB(0x00, 0xFF, 0x7F)),
        new Mapping("SteelBlue", new RGB(0x46, 0x82, 0xB4)), new Mapping("Tan", new RGB(0xD2, 0xB4, 0x8C)),
        new Mapping("Teal", new RGB(0x00, 0x80, 0x80)), new Mapping("Thistle", new RGB(0xD8, 0xBF, 0xD8)),
        new Mapping("Tomato", new RGB(0xFF, 0x63, 0x47)), new Mapping("Turquoise", new RGB(0x40, 0xE0, 0xD0)),
        new Mapping("Violet", new RGB(0xEE, 0x82, 0xEE)), new Mapping("Wheat", new RGB(0xF5, 0xDE, 0xB3)),
        new Mapping("White", new RGB(0xFF, 0xFF, 0xFF)), new Mapping("WhiteSmoke", new RGB(0xF5, 0xF5, 0xF5)),
        new Mapping("Yellow", new RGB(0xFF, 0xFF, 0x00)), new Mapping("YellowGreen", new RGB(0x9A, 0xCD, 0x32))
    };

    public static void bindTo(ResourceManager manager, FormText text) {
        for (Mapping m : colors) {
            text.setColor(m.name, manager.createColor(m.rgb));
        }
    }

}
