/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.util;

/**
 * @author Tuukka Lehtonen
 */
public final class TagUtil {

    /**
     * No operation, does nothing. Just a convenience for replacing a tag with
     * no tag in code.
     * 
     * @param text the input
     * @return the specified input text
     */
    public static String nop(String text) {
        return text;
    }

    public static String tag(String s, String tag) {
        if (tag == null)
            return s;

        StringBuilder b = new StringBuilder(s.length() + tag.length()*2 + 6);
        b.append('<');
        b.append(tag);
        b.append('>');
        b.append(s);
        b.append("</");
        b.append(tag);
        b.append('>');
        return b.toString();
    }
    
    /**
     * @param s
     * @param tag
     * @param attrs attribute+value pairs 
     * @return
     */
    public static String tag(String s, String tag, String...attrs) {
        assert (attrs.length % 2 == 0);
        StringBuilder b = new StringBuilder(s.length() + tag.length()*2 + 30);
        b.append('<');
        b.append(tag);
        for (int i = 0; i < attrs.length; i+=2) {
            b.append(' ');
            b.append(attrs[i]);
            b.append("=\"");
            b.append(attrs[i+1]);
            b.append('"');
        }
        b.append('>');
        b.append(s);
        b.append("</");
        b.append(tag);
        b.append('>');
        return b.toString();
    }

    // NEVER MIND THESE

    private static boolean isEnclosed(String s, String tag) {
        String trim = s.trim();
        int tagLen = tag.length();
        int len = trim.length();
        boolean startTag = (len >= tag.length() + 2) && (trim.charAt(0) == '<') && trim.startsWith(tag, 1) && (trim.charAt(1+tagLen) == '>');
        boolean endTag = (len >= tag.length()*2 + 5) && trim.startsWith("</", len - 1 - tagLen - 2) && trim.startsWith(tag, 1) && (trim.charAt(len - 1) == '>');
        return startTag && endTag;
    }

    public static void main(String[] args) {
        assertTrue(isEnclosed("form", "form") == false);
        assertTrue(isEnclosed("<form></form>", "form") == true);
        assertTrue(isEnclosed("<form>    </form>", "form") == true);
        assertTrue(isEnclosed("   <form></form>", "form") == true);
        assertTrue(isEnclosed("<form></form>   ", "form") == true);
        assertTrue(isEnclosed("   <form></form>   ", "form") == true);
        assertTrue(isEnclosed("<form>FOO</form>", "form") == true);
        assertTrue(isEnclosed("<form>   FOO </form>", "form") == true);
    }

    private static void assertTrue(boolean b) {
        if (b == false)
            throw new AssertionError(false);
    }

}
