/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.util;

import java.net.URI;

/**
 * @author Tuukka Lehtonen
 */
public final class HtmlUtil {

    /**
     * Encloses the specified text within a <code>&lt;form&gt;</code> tag.
     * 
     * @param text the text to enclose
     * @return the enclosed text 
     */
    public static String html(String text) {
        return TagUtil.tag(TagUtil.tag("", "head") + TagUtil.tag(TagUtil.tag(text, "pre"), "body"), "html");
    }

    /**
     * Produces a standard HTML <code>&lt;a&gt;</code> anchor tag with the specified
     * contents.
     * 
     * @param href the <code>href</code> attribute value of the produced anchor
     *        (&lt;a href="<code>href</code>"&gt;&lt;/a&gt;)
     * @param text the <code>text</code> inside the anchor element (&lt;a&gt;
     *        <code>text</code>&lt;/a&gt;)
     * @return the anchor
     */
    public static String a(String href, String text) {
        return TagUtil.tag(text, "a", "href", href);
    }

    /**
     * Produces a standard HTML <code>&lt;a&gt;</code> anchor tag with the specified
     * contents.
     * 
     * @param href the <code>href</code> attribute value of the produced anchor
     *        (&lt;a href="<code>href</code>"&gt;&lt;/a&gt;)
     * @param text the <code>text</code> inside the anchor element (&lt;a&gt;
     *        <code>text</code>&lt;/a&gt;)
     * @return the anchor
     */
    public static String a(URI href, String text) {
        return a(href.toASCIIString(), text);
    }

    /**
     * Produces a standard HTML <code>&lt;a&gt;</code> anchor tag with the
     * specified contents.
     * 
     * @param scheme the <code>&lt;scheme&gt;</code> part of the URI of form
     *        <code>&ltscheme&gt:&lt;scheme-specific-part&gt;</code>
     * @param identifier the <code>&lt;scheme-specific-part&gt;</code> part of
     *        the URI of form
     *        <code>&ltscheme&gt:&lt;scheme-specific-part&gt;</code>
     * @param text the <code>text</code> inside the anchor element (&lt;a&gt;
     *        <code>text</code>&lt;/a&gt;)
     * @return the anchor
     */
    public static String a(String scheme, String identifier, String text) {
        return TagUtil.tag(text, "a", "href", scheme +  ":" + identifier);
    }

    /**
     * Encloses the specified text within a <code>&lt;p&gt;</code> tag.
     * 
     * @param text the text to enclose
     * @return the enclosed text
     */
    public static String p(String text) {
        return TagUtil.tag(text, "p");
    }

}
