/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message;

/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

/**
 * A concrete multi-status implementation,
 * suitable either for instantiating or subclassing.
 * <p>
 * This class can be used without OSGi running.
 * </p>
 */
public class DetailMultiStatus extends MultiStatus implements IDetailStatus {

    private int severity;

    private String detailedDescription;

    /**
     * Creates and returns a new multi-status object with the given children.
     *
     * @param pluginId the unique identifier of the relevant plug-in
     * @param code the plug-in-specific status code
     * @param newChildren the list of children status objects
     * @param message a human-readable message, localized to the
     *    current locale
     * @param exception a low-level exception, or <code>null</code> if not
     *    applicable
     */
    public DetailMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
        super(pluginId, code, newChildren, message, exception);
        setDetailedDescription(null);
    }

    public DetailMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, String detailedDescription, Throwable exception) {
        super(pluginId, code, newChildren, message, exception);
        setDetailedDescription(detailedDescription);
    }

    /**
     * Creates and returns a new multi-status object with no children.
     *
     * @param pluginId the unique identifier of the relevant plug-in
     * @param code the plug-in-specific status code
     * @param message a human-readable message, localized to the
     *    current locale
     * @param exception a low-level exception, or <code>null</code> if not
     *    applicable
     */
    public DetailMultiStatus(String pluginId, int code, String message, Throwable exception) {
        super(pluginId, code, message, exception);
        setDetailedDescription(null);
    }

    public DetailMultiStatus(String pluginId, int code, String message, String detailedDescription, Throwable exception) {
        super(pluginId, code, message, exception);
        setDetailedDescription(detailedDescription);
    }

    /**
     * Sets the severity.
     *
     * @param severity the severity; one of <code>OK</code>, <code>ERROR</code>,
     * <code>INFO</code>, <code>WARNING</code>,  or <code>CANCEL</code>
     */
    @Override
    protected void setSeverity(int severity) {
        Assert.isLegal(severity == OK || severity == ERROR || severity == WARNING || severity == INFO || severity == CANCEL || severity == DEBUG);
        this.severity = severity;
    }

    /* (non-Javadoc)
     * @see org.eclipse.core.runtime.Status#getSeverity()
     */
    @Override
    public int getSeverity() {
        return severity;
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IStatus2#getDetailedDescription()
     */
    @Override
    public String getDetailedDescription() {
        return detailedDescription;
    }

    /**
     * @param detailedDescription
     */
    public void setDetailedDescription(String detailedDescription) {
        if (detailedDescription == null)
            this.detailedDescription = ""; //$NON-NLS-1$
        else
            this.detailedDescription = detailedDescription;
    }

    /**
     * Returns a string representation of the status, suitable
     * for debugging purposes only.
     */
    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status2 "); //$NON-NLS-1$
        if (severity == OK) {
            buf.append("OK"); //$NON-NLS-1$
        } else if (severity == ERROR) {
            buf.append("ERROR"); //$NON-NLS-1$
        } else if (severity == WARNING) {
            buf.append("WARNING"); //$NON-NLS-1$
        } else if (severity == INFO) {
            buf.append("INFO"); //$NON-NLS-1$
        } else if (severity == CANCEL) {
            buf.append("CANCEL"); //$NON-NLS-1$
        } else if (severity == DEBUG) {
            buf.append("DEBUG"); //$NON-NLS-1$
        } else {
            buf.append("severity="); //$NON-NLS-1$
            buf.append(severity);
        }
        buf.append(": "); //$NON-NLS-1$
        buf.append(getPlugin());
        buf.append(" code="); //$NON-NLS-1$
        buf.append(getCode());
        buf.append(' ');
        buf.append(getMessage());
        buf.append(' ');
        buf.append(getDetailedDescription());
        buf.append(' ');
        buf.append(getException());
        return buf.toString();
    }

}
