/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;

public class NotInstruction implements IInstruction {
	IInstruction instruction;

	public NotInstruction(IInstruction instruction) {
		this.instruction = instruction;
	}

	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
		return instruction.deny(g, bindings);
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		instruction.collectVariables(reads, writes);		
	}

	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
		return instruction.claim(g, bindings);
	}

	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		instruction.doDeny(g, bindings);		
	}

	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
		instruction.doClaim(g, bindings);		
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		instruction.mapVariables(map);		
	}

	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) {
		return IInstruction.FAILURE;
	}

	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		if(instruction.query(g, bindings)==IInstruction.FAILURE)
			return null;
		else
			return IInstruction.FAILURE;
	}

	@Override
	public void toString(StringBuilder b, int indent) {
		b.append("not ");
		instruction.toString(b, indent);		
	}	
	
}
