/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.instructions.AndInstruction;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class ConstraintConjunction implements IConstraint {

	IConstraint[] constraints;
	
	public ConstraintConjunction(IConstraint... constraints) {
		this.constraints = constraints;
	}

	@Override
	public ImmutableSet<Resource> binds() {
		ImmutableSet<Resource> ret = ImmutableSet.empty();
		for(IConstraint c : constraints)
			ret = ret.addAll(c.binds());
		return ret;
	}

	@Override
	public IInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds,
			ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
		IInstruction[] instructions = new IInstruction[constraints.length];
		for(int i=0;i<constraints.length;++i) {
			instructions[i] = constraints[i].createInstruction(variableIds, bound);
			bound = bound.addAll(constraints[i].binds());
		}
		return new AndInstruction(instructions);
	}

	@Override
	public int isApplicable(ImmutableSet<Resource> bound) {
		int ret = Integer.MAX_VALUE;
		for(int i=0;i<constraints.length;++i) {
			int temp = constraints[i].isApplicable(bound);
			if(temp < ret) {
				if(temp == 0)
					return 0;
				ret = temp;				
			}
			bound = bound.addAll(constraints[i].binds());
		}
		return ret;
	}

	
	
}
