package org.simantics.logging.ui.handlers;

import java.nio.file.Files;
import java.nio.file.Paths;

import javax.inject.Named;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.logging.LogCollector;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveLogFilesHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveLogFilesHandler.class);

    private static final String[] FILTER_NAMES = { "ZIP-archive", "AllFiles (*.*)" };
    private static final String[] FILTER_EXTENSIONS = { "*.zip", "*.*" };
    private static final String USER_HOME = System.getProperty("user.home");

    @Execute
    public void execute(@Named(IServiceConstants.ACTIVE_SHELL) Shell shell) {
        FileDialog dialog = new FileDialog(shell, SWT.SAVE);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTENSIONS);
        if (USER_HOME != null) {
            if (Files.exists(Paths.get(USER_HOME))) {
                dialog.setFilterPath(USER_HOME);
            }
        }
        String actualFileName = LogCollector.archiveFileName();
        dialog.setFileName(actualFileName);

        String destination = dialog.open();
        if (destination != null) {
            if (LOGGER.isDebugEnabled())
                LOGGER.debug("Destination for saving log files is {}", destination);
            try {
                LogCollector.archiveLogs(destination);
            } catch (Throwable t) {
                LOGGER.error("Could not save log files to ZIP", t);
                ExceptionUtils.logAndShowError("Could not save log files to ZIP", t);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No destination selected for saving logs");
            }
        }
    }

}
