package org.simantics.logging;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;

/**
 * Class for modifying the active logging configuration
 * 
 * @author Jani Simomaa
 *
 */
public final class LogConfigurator {

    private static final Logger LOGGER = LoggerFactory.getLogger(LogConfigurator.class);

    private LogConfigurator() {
    }

    /**
     * Sets logging level to represent the given argument
     * 
     * @param level ERROR WARN INFO DEBUG TRACE
     */
    public static void setLoggingLevel(String level) {
        if (LOGGER.isInfoEnabled())
            LOGGER.info("Setting logger level to {}", level);
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        Level ll = getLoggerLevel(level);
        List<ch.qos.logback.classic.Logger> loggerList = context.getLoggerList();
        loggerList.forEach(l -> l.setLevel(ll));
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("Loggers installed {}", loggerList);
    }

    public static void setLoggingLevelForLogger(String logger, String level) {
        if (LOGGER.isInfoEnabled())
            LOGGER.info("Setting logger level to {} for loggers {}", level, logger);
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        Level ll = getLoggerLevel(level);
        ch.qos.logback.classic.Logger loggerList = context.getLogger(logger);
        loggerList.setLevel(ll);
        if (LOGGER.isDebugEnabled())
            LOGGER.debug("Loggers installed {}", loggerList);
    }

    private static Level getLoggerLevel(String level) {
        return Level.valueOf(level);
    }
}
