/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.common.IssuesOfSeverity;
import org.simantics.issues.ui.ontology.IssueUIResource;
import org.simantics.layer0.Layer0;

public class SeverityFolderLabelRule implements LabelRule {
	
    private final String DESCRIPTION = ColumnKeys.SINGLE;

	final Resource rule;
	
	public SeverityFolderLabelRule(Resource rule) {
		this.rule = rule;
	}
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String,String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
    	
    	Layer0 L0 = Layer0.getInstance(graph);
        IssueUIResource UI = IssueUIResource.getInstance(graph);
    	Resource project = (Resource)content;
    	Resource severity = graph.getSingleObject(rule, UI.IssueBrowseContext_SeverityFolderLabelRule_HasSeverity);
    	String severityName = graph.getRelatedValue(severity, L0.HasName, Bindings.STRING);
        Set<Variable> issues = graph.syncRequest(new IssuesOfSeverity(project, severity));
        
        if(issues.size() > 1) {
        	return Collections.singletonMap(DESCRIPTION, severityName + "s (" + issues.size() + " items)");
        } else {
        	return Collections.singletonMap(DESCRIPTION, severityName + "s (1 item)");
        }
        
    }
    
}
