package org.simantics.issues.ui;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class All {
	
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> b")
    public static Object issueSourceSelected(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	
    	return new FunctionImpl1<Object, Boolean>() {
    		
    	    @Override
    	    public Boolean apply(Object _event) {
    	    	
    	    	Event event = (Event)_event;
    	    	
    	    	final TreeItem item = (TreeItem)event.item;
    	    	if (item == null)
    	    		return null
;
    	    	NodeContext context = (NodeContext)item.getData();
    	    	
                final boolean checked = item.getChecked();
                final Resource issueSource = ResourceAdaptionUtils.toSingleResource(context);
                try {
                    VirtualGraphSupport support = SimanticsUI.getSession().getService(VirtualGraphSupport.class);
                    SimanticsUI.getSession().syncRequest(new WriteRequest(support.getWorkspacePersistent("preferences")) {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                        	IssueResource ISSUE = IssueResource.getInstance(graph);
                            if (checked) {
                                graph.claim(issueSource, ISSUE.IssueSource_Selected, issueSource);
                            } else {
                                graph.deny(issueSource, ISSUE.IssueSource_Selected);
                            }
                        }
                    });
                } catch (DatabaseException e) {
                    ErrorLogger.defaultLogError(e);
                }
    	        
    	        return null;
    	        
    	    }
    		
    	};
        
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Resource")
    public static Resource activeModel(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	Resource project = ScenegraphLoaderUtils.getPossibleResourceSelection(graph, context);
    	return graph.sync(new PossibleActiveModel(project));
    }
    
}
