package org.simantics.issues.ui.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class IssueUIResource {
    
    public final Resource ActionContext;
    public final Resource Actions;
    public final Resource Actions_Help;
    public final Resource Actions_Hide;
    public final Resource Actions_Resolve;
    public final Resource Actions_SetSeverityAction;
    public final Resource Actions_SetSeverityAction_HasSeverity;
    public final Resource Actions_SetSeverityAction_HasSeverity_Inverse;
    public final Resource Actions_SeverityActionCategory;
    public final Resource Actions_Unhide;
    public final Resource Actions_Unresolve;
    public final Resource BatchIssueSourceBrowseContext;
    public final Resource BatchIssueSourceBrowseContext_IssueSourceCheckRule;
    public final Resource Functions;
    public final Resource Functions_activeModel;
    public final Resource Functions_issueSourceSelected;
    public final Resource IssueBrowseContext;
    public final Resource IssueBrowseContext_DynamicIssueHierarchyNode;
    public final Resource IssueBrowseContext_DynamicIssueSourceHierarchyRule;
    public final Resource IssueBrowseContext_DynamicIssueSourceRule;
    public final Resource IssueBrowseContext_ErrorFolder;
    public final Resource IssueBrowseContext_FatalFolder;
    public final Resource IssueBrowseContext_InfoFolder;
    public final Resource IssueBrowseContext_Issue;
    public final Resource IssueBrowseContext_IssueContextDropAction;
    public final Resource IssueBrowseContext_IssueImageDecorationRule;
    public final Resource IssueBrowseContext_IssueImageRule;
    public final Resource IssueBrowseContext_IssueLabelDecorationRule;
    public final Resource IssueBrowseContext_IssueLabelRule;
    public final Resource IssueBrowseContext_NoteFolder;
    public final Resource IssueBrowseContext_SeverityChildRule;
    public final Resource IssueBrowseContext_SeverityChildRule_HasSeverity;
    public final Resource IssueBrowseContext_SeverityChildRule_HasSeverity_Inverse;
    public final Resource IssueBrowseContext_SeverityFolderLabelRule;
    public final Resource IssueBrowseContext_SeverityFolderLabelRule_HasSeverity;
    public final Resource IssueBrowseContext_SeverityFolderLabelRule_HasSeverity_Inverse;
    public final Resource IssueBrowseContext_SeverityFolderRule;
    public final Resource IssueBrowseContext_SeverityFolderRule_HasSeverity;
    public final Resource IssueBrowseContext_SeverityFolderRule_HasSeverity_Inverse;
    public final Resource IssueBrowseContext_UnknownFolder;
    public final Resource IssueBrowseContext_UserIssueTest;
    public final Resource IssueBrowseContext_WarningFolder;
    public final Resource IssueView;
    public final Resource IssueView_Active;
    public final Resource IssueView_Active_Explorer;
    public final Resource IssueView_Batch;
    public final Resource IssueView_BatchColumn;
    public final Resource IssueView_Batch_Explorer;
    public final Resource IssueView_Description;
    public final Resource IssueView_Path;
    public final Resource IssueView_Resource;
    public final Resource ShowHiddenIssues;
    public final Resource ShowHiddenIssues_Inverse;
    public final Resource ShowNormalIssues;
    public final Resource ShowNormalIssues_Inverse;
    public final Resource ShowUserIssues;
    public final Resource ShowUserIssues_Inverse;
        
    public static class URIs {
        public static final String ActionContext = "http://www.simantics.org/IssueUI-1.1/ActionContext";
        public static final String Actions = "http://www.simantics.org/IssueUI-1.1/Actions";
        public static final String Actions_Help = "http://www.simantics.org/IssueUI-1.1/Actions/Help";
        public static final String Actions_Hide = "http://www.simantics.org/IssueUI-1.1/Actions/Hide";
        public static final String Actions_Resolve = "http://www.simantics.org/IssueUI-1.1/Actions/Resolve";
        public static final String Actions_SetSeverityAction = "http://www.simantics.org/IssueUI-1.1/Actions/SetSeverityAction";
        public static final String Actions_SetSeverityAction_HasSeverity = "http://www.simantics.org/IssueUI-1.1/Actions/SetSeverityAction/HasSeverity";
        public static final String Actions_SetSeverityAction_HasSeverity_Inverse = "http://www.simantics.org/IssueUI-1.1/Actions/SetSeverityAction/HasSeverity/Inverse";
        public static final String Actions_SeverityActionCategory = "http://www.simantics.org/IssueUI-1.1/Actions/SeverityActionCategory";
        public static final String Actions_Unhide = "http://www.simantics.org/IssueUI-1.1/Actions/Unhide";
        public static final String Actions_Unresolve = "http://www.simantics.org/IssueUI-1.1/Actions/Unresolve";
        public static final String BatchIssueSourceBrowseContext = "http://www.simantics.org/IssueUI-1.1/BatchIssueSourceBrowseContext";
        public static final String BatchIssueSourceBrowseContext_IssueSourceCheckRule = "http://www.simantics.org/IssueUI-1.1/BatchIssueSourceBrowseContext/IssueSourceCheckRule";
        public static final String Functions = "http://www.simantics.org/IssueUI-1.1/Functions";
        public static final String Functions_activeModel = "http://www.simantics.org/IssueUI-1.1/Functions/activeModel";
        public static final String Functions_issueSourceSelected = "http://www.simantics.org/IssueUI-1.1/Functions/issueSourceSelected";
        public static final String IssueBrowseContext = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext";
        public static final String IssueBrowseContext_DynamicIssueHierarchyNode = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/DynamicIssueHierarchyNode";
        public static final String IssueBrowseContext_DynamicIssueSourceHierarchyRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/DynamicIssueSourceHierarchyRule";
        public static final String IssueBrowseContext_DynamicIssueSourceRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/DynamicIssueSourceRule";
        public static final String IssueBrowseContext_ErrorFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/ErrorFolder";
        public static final String IssueBrowseContext_FatalFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/FatalFolder";
        public static final String IssueBrowseContext_InfoFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/InfoFolder";
        public static final String IssueBrowseContext_Issue = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/Issue";
        public static final String IssueBrowseContext_IssueContextDropAction = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/IssueContextDropAction";
        public static final String IssueBrowseContext_IssueImageDecorationRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/IssueImageDecorationRule";
        public static final String IssueBrowseContext_IssueImageRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/IssueImageRule";
        public static final String IssueBrowseContext_IssueLabelDecorationRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/IssueLabelDecorationRule";
        public static final String IssueBrowseContext_IssueLabelRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/IssueLabelRule";
        public static final String IssueBrowseContext_NoteFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/NoteFolder";
        public static final String IssueBrowseContext_SeverityChildRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityChildRule";
        public static final String IssueBrowseContext_SeverityChildRule_HasSeverity = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityChildRule/HasSeverity";
        public static final String IssueBrowseContext_SeverityChildRule_HasSeverity_Inverse = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityChildRule/HasSeverity/Inverse";
        public static final String IssueBrowseContext_SeverityFolderLabelRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderLabelRule";
        public static final String IssueBrowseContext_SeverityFolderLabelRule_HasSeverity = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderLabelRule/HasSeverity";
        public static final String IssueBrowseContext_SeverityFolderLabelRule_HasSeverity_Inverse = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderLabelRule/HasSeverity/Inverse";
        public static final String IssueBrowseContext_SeverityFolderRule = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderRule";
        public static final String IssueBrowseContext_SeverityFolderRule_HasSeverity = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderRule/HasSeverity";
        public static final String IssueBrowseContext_SeverityFolderRule_HasSeverity_Inverse = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/SeverityFolderRule/HasSeverity/Inverse";
        public static final String IssueBrowseContext_UnknownFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/UnknownFolder";
        public static final String IssueBrowseContext_UserIssueTest = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/UserIssueTest";
        public static final String IssueBrowseContext_WarningFolder = "http://www.simantics.org/IssueUI-1.1/IssueBrowseContext/WarningFolder";
        public static final String IssueView = "http://www.simantics.org/IssueUI-1.1/IssueView";
        public static final String IssueView_Active = "http://www.simantics.org/IssueUI-1.1/IssueView/Active";
        public static final String IssueView_Active_Explorer = "http://www.simantics.org/IssueUI-1.1/IssueView/Active/Explorer";
        public static final String IssueView_Batch = "http://www.simantics.org/IssueUI-1.1/IssueView/Batch";
        public static final String IssueView_BatchColumn = "http://www.simantics.org/IssueUI-1.1/IssueView/BatchColumn";
        public static final String IssueView_Batch_Explorer = "http://www.simantics.org/IssueUI-1.1/IssueView/Batch/Explorer";
        public static final String IssueView_Description = "http://www.simantics.org/IssueUI-1.1/IssueView/Description";
        public static final String IssueView_Path = "http://www.simantics.org/IssueUI-1.1/IssueView/Path";
        public static final String IssueView_Resource = "http://www.simantics.org/IssueUI-1.1/IssueView/Resource";
        public static final String ShowHiddenIssues = "http://www.simantics.org/IssueUI-1.1/ShowHiddenIssues";
        public static final String ShowHiddenIssues_Inverse = "http://www.simantics.org/IssueUI-1.1/ShowHiddenIssues/Inverse";
        public static final String ShowNormalIssues = "http://www.simantics.org/IssueUI-1.1/ShowNormalIssues";
        public static final String ShowNormalIssues_Inverse = "http://www.simantics.org/IssueUI-1.1/ShowNormalIssues/Inverse";
        public static final String ShowUserIssues = "http://www.simantics.org/IssueUI-1.1/ShowUserIssues";
        public static final String ShowUserIssues_Inverse = "http://www.simantics.org/IssueUI-1.1/ShowUserIssues/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public IssueUIResource(ReadGraph graph) {
        ActionContext = getResourceOrNull(graph, URIs.ActionContext);
        Actions = getResourceOrNull(graph, URIs.Actions);
        Actions_Help = getResourceOrNull(graph, URIs.Actions_Help);
        Actions_Hide = getResourceOrNull(graph, URIs.Actions_Hide);
        Actions_Resolve = getResourceOrNull(graph, URIs.Actions_Resolve);
        Actions_SetSeverityAction = getResourceOrNull(graph, URIs.Actions_SetSeverityAction);
        Actions_SetSeverityAction_HasSeverity = getResourceOrNull(graph, URIs.Actions_SetSeverityAction_HasSeverity);
        Actions_SetSeverityAction_HasSeverity_Inverse = getResourceOrNull(graph, URIs.Actions_SetSeverityAction_HasSeverity_Inverse);
        Actions_SeverityActionCategory = getResourceOrNull(graph, URIs.Actions_SeverityActionCategory);
        Actions_Unhide = getResourceOrNull(graph, URIs.Actions_Unhide);
        Actions_Unresolve = getResourceOrNull(graph, URIs.Actions_Unresolve);
        BatchIssueSourceBrowseContext = getResourceOrNull(graph, URIs.BatchIssueSourceBrowseContext);
        BatchIssueSourceBrowseContext_IssueSourceCheckRule = getResourceOrNull(graph, URIs.BatchIssueSourceBrowseContext_IssueSourceCheckRule);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_activeModel = getResourceOrNull(graph, URIs.Functions_activeModel);
        Functions_issueSourceSelected = getResourceOrNull(graph, URIs.Functions_issueSourceSelected);
        IssueBrowseContext = getResourceOrNull(graph, URIs.IssueBrowseContext);
        IssueBrowseContext_DynamicIssueHierarchyNode = getResourceOrNull(graph, URIs.IssueBrowseContext_DynamicIssueHierarchyNode);
        IssueBrowseContext_DynamicIssueSourceHierarchyRule = getResourceOrNull(graph, URIs.IssueBrowseContext_DynamicIssueSourceHierarchyRule);
        IssueBrowseContext_DynamicIssueSourceRule = getResourceOrNull(graph, URIs.IssueBrowseContext_DynamicIssueSourceRule);
        IssueBrowseContext_ErrorFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_ErrorFolder);
        IssueBrowseContext_FatalFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_FatalFolder);
        IssueBrowseContext_InfoFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_InfoFolder);
        IssueBrowseContext_Issue = getResourceOrNull(graph, URIs.IssueBrowseContext_Issue);
        IssueBrowseContext_IssueContextDropAction = getResourceOrNull(graph, URIs.IssueBrowseContext_IssueContextDropAction);
        IssueBrowseContext_IssueImageDecorationRule = getResourceOrNull(graph, URIs.IssueBrowseContext_IssueImageDecorationRule);
        IssueBrowseContext_IssueImageRule = getResourceOrNull(graph, URIs.IssueBrowseContext_IssueImageRule);
        IssueBrowseContext_IssueLabelDecorationRule = getResourceOrNull(graph, URIs.IssueBrowseContext_IssueLabelDecorationRule);
        IssueBrowseContext_IssueLabelRule = getResourceOrNull(graph, URIs.IssueBrowseContext_IssueLabelRule);
        IssueBrowseContext_NoteFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_NoteFolder);
        IssueBrowseContext_SeverityChildRule = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityChildRule);
        IssueBrowseContext_SeverityChildRule_HasSeverity = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityChildRule_HasSeverity);
        IssueBrowseContext_SeverityChildRule_HasSeverity_Inverse = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityChildRule_HasSeverity_Inverse);
        IssueBrowseContext_SeverityFolderLabelRule = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderLabelRule);
        IssueBrowseContext_SeverityFolderLabelRule_HasSeverity = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderLabelRule_HasSeverity);
        IssueBrowseContext_SeverityFolderLabelRule_HasSeverity_Inverse = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderLabelRule_HasSeverity_Inverse);
        IssueBrowseContext_SeverityFolderRule = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderRule);
        IssueBrowseContext_SeverityFolderRule_HasSeverity = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderRule_HasSeverity);
        IssueBrowseContext_SeverityFolderRule_HasSeverity_Inverse = getResourceOrNull(graph, URIs.IssueBrowseContext_SeverityFolderRule_HasSeverity_Inverse);
        IssueBrowseContext_UnknownFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_UnknownFolder);
        IssueBrowseContext_UserIssueTest = getResourceOrNull(graph, URIs.IssueBrowseContext_UserIssueTest);
        IssueBrowseContext_WarningFolder = getResourceOrNull(graph, URIs.IssueBrowseContext_WarningFolder);
        IssueView = getResourceOrNull(graph, URIs.IssueView);
        IssueView_Active = getResourceOrNull(graph, URIs.IssueView_Active);
        IssueView_Active_Explorer = getResourceOrNull(graph, URIs.IssueView_Active_Explorer);
        IssueView_Batch = getResourceOrNull(graph, URIs.IssueView_Batch);
        IssueView_BatchColumn = getResourceOrNull(graph, URIs.IssueView_BatchColumn);
        IssueView_Batch_Explorer = getResourceOrNull(graph, URIs.IssueView_Batch_Explorer);
        IssueView_Description = getResourceOrNull(graph, URIs.IssueView_Description);
        IssueView_Path = getResourceOrNull(graph, URIs.IssueView_Path);
        IssueView_Resource = getResourceOrNull(graph, URIs.IssueView_Resource);
        ShowHiddenIssues = getResourceOrNull(graph, URIs.ShowHiddenIssues);
        ShowHiddenIssues_Inverse = getResourceOrNull(graph, URIs.ShowHiddenIssues_Inverse);
        ShowNormalIssues = getResourceOrNull(graph, URIs.ShowNormalIssues);
        ShowNormalIssues_Inverse = getResourceOrNull(graph, URIs.ShowNormalIssues_Inverse);
        ShowUserIssues = getResourceOrNull(graph, URIs.ShowUserIssues);
        ShowUserIssues_Inverse = getResourceOrNull(graph, URIs.ShowUserIssues_Inverse);
    }
    
    public static IssueUIResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        IssueUIResource ret = session.peekService(IssueUIResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new IssueUIResource(qc.getIndependentGraph(graph));
            session.registerService(IssueUIResource.class, ret);
        }
        return ret;
    }
    
    public static IssueUIResource getInstance(RequestProcessor session) throws DatabaseException {
        IssueUIResource ret = session.peekService(IssueUIResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<IssueUIResource>() {
                public IssueUIResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new IssueUIResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(IssueUIResource.class, ret);
        }
        return ret;
    }
    
}

