package org.simantics.issues.common;

import java.util.Collections;
import java.util.List;

import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.issue.AnonymousIssue;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

public class StandardIssueDescription extends ResourceRead<Issue> {

	public StandardIssueDescription(Resource issue) {
		super(issue);
	}
	
	@Override
	public Issue perform(ReadGraph graph) throws DatabaseException {

		IssueResource ISSUE = IssueResource.getInstance(graph);
		Resource type = graph.getPossibleType(resource, ISSUE.Issue);
		if(type == null) return null;
		Resource list = graph.getPossibleObject(resource, ISSUE.Issue_HasContexts);
		if(list == null) {
		
		    if(graph.isInheritedFrom(type, ISSUE.Sources_DependencyTracker_AnonymousIssue))
		        return new AnonymousIssue(type, Collections.singletonList(resource));
		    else
		        return new StandardIssue(type, Collections.singletonList(resource));
			
		} else {

			List<Resource> contexts = ListUtils.toPossibleList(graph, list);
			if(contexts == null) return null;
			
			if(graph.isInheritedFrom(type, ISSUE.Sources_DependencyTracker_AnonymousIssue))
                return new AnonymousIssue(type, contexts);
			else
			    return new StandardIssue(type, contexts);
			
		}
		
	}
	
}