/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.function.Function2;

public interface IssueSource {

	/*
	 * Updates the issue data model managed by this source
	 */
	void update(WriteGraph graph, List<Resource> resources) throws DatabaseException;
	boolean needUpdate(ReadGraph graph, List<Resource> resources) throws DatabaseException;
	/*
	 * Dirty listener is fired when a source detects potential changes. False alarms are acceptable.
	 */
	void addDirtyListener(Function2<ReadGraph, List<Resource>, Boolean> runnable);
	void removeDirtyListener(Function2<ReadGraph, List<Resource>, Boolean> runnable);
	
}
