/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.issues.Severity;

/**
 * @author Tuukka Lehtonen
 */
public class ChildMaxIssueSeverity extends TernaryAsyncRead<Resource, Resource, Set<Resource>, Severity>{

    public ChildMaxIssueSeverity(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super(resource, childRelation, typesToRecurse);
    }

//    @Override
//    public Severity perform(ReadGraph graph) throws DatabaseException {
//        Severity maxSeverity = null;
//        //System.out.println("severityForChildren: " + NameUtils.getSafeName(graph, resource));
//        for (Resource child : graph.getObjects(resource, resource2)) {
//            Severity s = graph.syncRequest(new MaxIssueSeverityRecursive(child));
//            maxSeverity = Severity.moreSevere(maxSeverity, s);
//        }
//        //System.out.println("severityForChildren: " + NameUtils.getSafeName(graph, resource) + " : " + maxSeverity);
//        return maxSeverity;
//    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        //System.out.println(getClass().getSimpleName() + ": " + parameter);
        
        graph.forTypes(parameter, new AsyncProcedure<Set<Resource>>() {
            @Override
            public void execute(AsyncReadGraph graph, Set<Resource> result) {
                if (!Collections.disjoint(parameter3, result)) {
                    checkChildren(graph, procedure);
                } else {
                    procedure.execute(graph, null);
                }
            }
            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    protected void checkChildren(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        graph.forEachObject(parameter, parameter2, new AsyncMultiProcedure<Resource>() {
            AtomicReference<Severity> maxSeverity = new AtomicReference<Severity>();
            @Override
            public void execute(AsyncReadGraph graph, Resource child) {
                graph.asyncRequest(new MaxIssueSeverityRecursive(child, parameter2, parameter3), new AsyncProcedure<Severity>() {
                    @Override
                    public void execute(AsyncReadGraph graph, Severity severity) {
                        if (severity != null) {
                            synchronized (maxSeverity) {
                                maxSeverity.set(Severity.moreSevere(maxSeverity.get(), severity));
                            }
                        }
                    }
                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        procedure.exception(graph, throwable);
                    }
                });
            }
            @Override
            public void finished(AsyncReadGraph graph) {
                procedure.execute(graph, maxSeverity.get());
            }
            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

}
