package org.simantics.image2.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ImageResource {
    
    public final Resource Functions;
    public final Resource Functions_data;
    public final Resource GifImage;
    public final Resource Image;
    public final Resource Image_HasFormat;
    public final Resource Image_HasFormat_Inverse;
    public final Resource Image_data;
    public final Resource Image_data_Inverse;
    public final Resource JpegImage;
    public final Resource PngImage;
    public final Resource SvgImage;
        
    public static class URIs {
        public static final String Functions = "http://www.simantics.org/Image2-1.2/Functions";
        public static final String Functions_data = "http://www.simantics.org/Image2-1.2/Functions/data";
        public static final String GifImage = "http://www.simantics.org/Image2-1.2/GifImage";
        public static final String Image = "http://www.simantics.org/Image2-1.2/Image";
        public static final String Image_HasFormat = "http://www.simantics.org/Image2-1.2/Image/HasFormat";
        public static final String Image_HasFormat_Inverse = "http://www.simantics.org/Image2-1.2/Image/HasFormat/Inverse";
        public static final String Image_data = "http://www.simantics.org/Image2-1.2/Image/data";
        public static final String Image_data_Inverse = "http://www.simantics.org/Image2-1.2/Image/data/Inverse";
        public static final String JpegImage = "http://www.simantics.org/Image2-1.2/JpegImage";
        public static final String PngImage = "http://www.simantics.org/Image2-1.2/PngImage";
        public static final String SvgImage = "http://www.simantics.org/Image2-1.2/SvgImage";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ImageResource(ReadGraph graph) {
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_data = getResourceOrNull(graph, URIs.Functions_data);
        GifImage = getResourceOrNull(graph, URIs.GifImage);
        Image = getResourceOrNull(graph, URIs.Image);
        Image_HasFormat = getResourceOrNull(graph, URIs.Image_HasFormat);
        Image_HasFormat_Inverse = getResourceOrNull(graph, URIs.Image_HasFormat_Inverse);
        Image_data = getResourceOrNull(graph, URIs.Image_data);
        Image_data_Inverse = getResourceOrNull(graph, URIs.Image_data_Inverse);
        JpegImage = getResourceOrNull(graph, URIs.JpegImage);
        PngImage = getResourceOrNull(graph, URIs.PngImage);
        SvgImage = getResourceOrNull(graph, URIs.SvgImage);
    }
    
    public static ImageResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ImageResource ret = session.peekService(ImageResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ImageResource(qc.getIndependentGraph(graph));
            session.registerService(ImageResource.class, ret);
        }
        return ret;
    }
    
    public static ImageResource getInstance(RequestProcessor session) throws DatabaseException {
        ImageResource ret = session.peekService(ImageResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ImageResource>() {
                public ImageResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ImageResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ImageResource.class, ret);
        }
        return ret;
    }
    
}

