package org.simantics.history.test;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.history.util.ClassDistribution;

/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/



public class TestClassDistribution {

	public static void main(String[] args) throws Exception {
				
		ClassDistribution ib = new ClassDistribution(1.1); 
		
		System.out.println( ib.getClassIndex(0.001) );
		System.out.println( ib.getClassIndex(0.01) );
		System.out.println( ib.getClassIndex(0.1) );
		System.out.println( ib.getClassIndex(1) );
		System.out.println( ib.getClassIndex(10) );
		System.out.println( ib.getClassIndex(100) );
		
		ib.addValue(0.00001);
		ib.addValue(0.000015);
		ib.addValue(0.001);
		ib.addValue(0.001);
		ib.addValue(0.001);
		ib.addValue(0.01);
		ib.addValue(0.1);
		ib.addValue(1);
//		ib.addInterval(10);
		ib.addValue(100);
		ib.addValue(1000);
		
		System.out.println(ib);
		
		System.out.println("Largest Class = "+ ib.getClassAvg( ib.getLargestClassIndex() ) );
		System.out.println("Median        = "+ ib.getMedian() );

		System.out.println( Math.log(2) );		
		System.out.println( Math.sqrt(0.5) );
		
		System.out.println("Test Serializer");
		Serializer s = Bindings.getSerializer( Bindings.getBinding( ClassDistribution.class ) );
		byte[] data = s.serialize( ib );
		ib = (ClassDistribution) s.deserialize(data);
		
		System.out.println();
		System.out.println("Deserialized:");
		System.out.println(ib);
		System.out.println("Largest Class = "+ ib.getClassAvg( ib.getLargestClassIndex() ) );
		System.out.println("Median        = "+ ib.getMedian() );
		
	}
	
}

