package org.simantics.graphviz.internal.process;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import org.simantics.graphviz.Activator;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.continuation.ComputationThread;

public class CreateXDot extends ComputationThread<Graph> {

    Graph graph;
    String algorithm;
    
    Process process;
    
    public CreateXDot(Graph graph, String algorithm) {
        this.graph = graph;
        this.algorithm = algorithm;
    }

    @Override
    protected void failWith(Exception exception) {
        process.destroy();
        super.failWith(exception);
    }
    
    @Override
    public void run() {
        try {
            File DOT_EXE = Activator.getDotExe();
            process = new ProcessBuilder(
                    DOT_EXE.toString(),
                    "-Txdot", "-K" + algorithm)
                    .directory(DOT_EXE.getParentFile())
                    .start();
            
            // Writes output to the process
            new Thread() {
                public void run() {
                    PrintStream stream = new PrintStream(process.getOutputStream());
                    graph.write(stream);
                    stream.close();
                }
            }.start();
            
            // Prints errors to stderr
            new Thread() {
                public void run() {
                    try {
                        InputStream errorStream = process.getErrorStream();
                        while(true) {
                            int c = errorStream.read();
                            if(c <= 0)
                                break;
                            System.err.print((char)c);
                        }
                        errorStream.close();
                    } catch(IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            
            InputStream inputStream = process.getInputStream();
            byte[] buffer = Graphs.read(inputStream);
            inputStream.close();       
            
            //System.out.println(new String(buffer));
            if(!isDone())
                doneWith(Graphs.parse(new ByteArrayInputStream(buffer)));
        } catch(Exception e) {
            failWith(e);
        }
    }

}
