/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

/**
 * A special kind of subgraph that is laid out separately.
 * A rectangle is drawn around the cluster and it is
 * labeled, if the cluster is given a label.
 * 
 * @author Hannu Niemist
 */
public class Cluster extends Subgraph {

    public Cluster(IGraph parent) {
        super(parent);
        id = "cluster_" + id;
    }

    public Cluster(IGraph parent, String label) {
        super(parent);
        id = "cluster_" + id;
        setLabel(label);
    }

    /**
     * Text label attached to objects. 
     */
    public void setLabel(String label) {
        set("label", label);        
    }
    
    /**
     * <p>
     * Basic drawing color for graphics, not text. For the latter, use the
     * fontcolor attribute. For edges, the value can either be a single color or
     * a colorList. In the latter case, the edge is drawn using parallel splines
     * or lines, one for each color in the list, in the order given. The head
     * arrow, if any, is drawn using the first color in the list, and the tail
     * arrow, if any, the second color. This supports the common case of drawing
     * opposing edges, but using parallel splines instead of separately routed
     * multiedges.
     * </p>
     * <p>Supports arbitrary RGB(A) colors in format #xxxxxx, where
     * each x is a hex digit. Supports also color names in x11 color chart.</p>
     */
    public void setColor(String color) {
        set("color", color);
    }
    
    /**
     * Color used for text.
     */
    public void setFontColor(String color) {
        set("fontcolor", color);
    }
    
    /**
     * Color used to fill the background of a node or cluster assuming style=filled. If fillcolor is not defined, color is used. (For clusters, if color is not defined, bgcolor is used.) If this is not defined, the default is used, except for shape=point or when the output format is MIF, which use black by default. Note that a cluster inherits the root graph's attributes if defined. Thus, if the root graph has defined a fillcolor, this will override a color or bgcolor attribute set for the cluster.
     */
    public void setFillColor(String color) {
        set("fillcolor", color);
    }
    
    /**
     * Set style for node or edge. For cluster subgraph, if "filled", the cluster box's background is filled.
     */
    public void setStyle(String style) {
        set("style", style);
    }

}
