/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.scenegraph;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.scenegraph.adapters.ISceneGraphProvider;
import org.simantics.scenegraph.g2d.G2DSceneGraph;

/**
 * @author Antti Villberg
 */
public interface ICanvasSceneGraphProvider extends ISceneGraphProvider {

    /**
     * @param context the canvas context to use for loading the scene graph
     *        contained by the context (see
     *        {@link ICanvasContext#getSceneGraph()})
     * @param modelURI URI of loaded model
     * @param RVI URI suffix of loaded scene graph structure source
     * @return
     */
    public G2DSceneGraph initializeSceneGraph(ICanvasContext context, String modelURI, String RVI);

    public ICanvasContext getCanvasContext();

}
