/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.g2d.routing.Connection;
import org.simantics.g2d.routing.Obstacle;
import org.simantics.g2d.routing.algorithm1.RouterOld;

public class TestRouter extends Frame {

	private static final long serialVersionUID = 2181877722124429003L;
	
	List<Obstacle> obstacles = new ArrayList<Obstacle>();
	List<Connection> connections = new ArrayList<Connection>();
	Connection connection;
	
	RouterOld router = new RouterOld();
	
	double startX, startY;
	double curX, curY;
	int mouseButtons = 0;

	public TestRouter() {
		addWindowListener(new WindowListener() {

			@Override
			public void windowActivated(WindowEvent e) {
			}

			@Override
			public void windowClosed(WindowEvent e) {		
			}

			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);			
			}

			@Override
			public void windowDeactivated(WindowEvent e) {
			}

			@Override
			public void windowDeiconified(WindowEvent e) {
			}

			@Override
			public void windowIconified(WindowEvent e) {
			}

			@Override
			public void windowOpened(WindowEvent e) {
			}
			
		});
		
		addMouseListener(new MouseListener() {

			@Override
			public void mouseClicked(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mousePressed(MouseEvent e) {
				mouseButtons = e.getButton();
				curX = startX = e.getX();
				curY = startY = e.getY();
				if(e.getButton() == MouseEvent.BUTTON3) {
					if(connection == null)
						connection = new Connection(new double[0], 0xf, 0xf);
					connection.routePath = 
						Arrays.copyOf(connection.routePath, connection.routePath.length+2);
					connection.routePath[connection.routePath.length-2] = curX;
					connection.routePath[connection.routePath.length-1] = curY;
				}
				repaint();
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				mouseButtons = 0;
				if(e.getButton() == MouseEvent.BUTTON1) {	
					double x0 = startX;
					double y0 = startY;
					double x1 = e.getX();
					double y1 = e.getY();
					if(x0 > x1) {
						double temp = x0;
						x0 = x1;
						x1 = temp;
					}
					if(y0 > y1) {
						double temp = y0;
						y0 = y1;
						y1 = temp;
					}
					Obstacle obs = new Obstacle(new Rectangle2D.Double(x0, y0, x1-x0, y1-y0));
					obstacles.add(obs);
					router.addObstacle(obs);
				}				
				
				repaint();				
			}
			
		});
		
		addMouseMotionListener(new MouseMotionListener() {

			@Override
			public void mouseDragged(MouseEvent e) {
				curX = e.getX();
				curY = e.getY();
				repaint();
			}

			@Override
			public void mouseMoved(MouseEvent e) {
				curX = e.getX();
				curY = e.getY();
				if(connection != null)
					repaint();
			}
			
		});
		
		addKeyListener(new KeyListener() {

			@Override
			public void keyPressed(KeyEvent e) {
				if(e.getKeyChar() == 'c') {
					if(connection != null) {
						connection.routePath = 
							Arrays.copyOf(connection.routePath, connection.routePath.length+2);
						connection.routePath[connection.routePath.length-2] = curX;
						connection.routePath[connection.routePath.length-1] = curY;
						
						connections.add(connection);
						router.addConnection(connection);						
					}
					connection = null;
					repaint();
				}
			}

			@Override
			public void keyReleased(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void keyTyped(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
			
		});
		
		setSize(640, 480);
		setVisible(true);
	}
	
	@Override
	public void paint(Graphics _g) {
		final Graphics2D g = (Graphics2D)_g;
		Map<Object, Object> hints = new HashMap<Object, Object>();
		hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		g.addRenderingHints(hints);
		
		/*Path2D path = new Path2D.Double();
		path.moveTo(0.0, 0.0);
		path.lineTo(100.0, 100.0);
		path.lineTo(400.0, 100.0);
				
		g.draw(path);
		*/
		
		g.setColor(Color.GRAY);
		g.setStroke(new BasicStroke(1.0f));
		for(Obstacle obs : obstacles)
			g.fill(obs.shape);		
		
		Obstacle curObs = null;
		if(mouseButtons == 1) {
			double x0 = startX;
			double y0 = startY;
			double x1 = curX;
			double y1 = curY;
			if(x0 > x1) {
				double temp = x0;
				x0 = x1;
				x1 = temp;
			}
			if(y0 > y1) {
				double temp = y0;
				y0 = y1;
				y1 = temp;
			}
			curObs = new Obstacle(new Rectangle2D.Double(x0, y0, x1-x0, y1-y0));
			g.fill(curObs.shape);
			router.addObstacle(curObs);
		}
		
		Connection curConnection = null;
		if(connection != null) {
			double[] points = Arrays.copyOf(connection.routePath, connection.routePath.length+2);
			points[points.length-2] = curX;
			points[points.length-1] = curY;
			curConnection = new Connection(points, connection.startDirections, connection.endDirections);
			router.addConnection(curConnection);
		}
		
		g.setColor(Color.BLACK);
		g.setStroke(new BasicStroke(3.0f));		
		for(Connection c : connections)
			draw(g, c);
		if(curConnection != null) {
			draw(g, curConnection);
			router.removeConnection(curConnection);
		}
		if(curObs != null)
			router.removeObstacle(curObs);		
	}
	
	public void draw(Graphics2D g, Connection c) {
		Path2D path = router.getPath(c);
		if(path == null)
			return;
		g.setColor(Color.WHITE);
		g.setStroke(stroke5);
		g.draw(path);
		g.setColor(Color.BLACK);
		g.setStroke(stroke1);
		g.draw(path);
		double[] points = c.routePath;
		for(int i=0;i<points.length;i+=2) {
			double x = points[i];
			double y = points[i+1];
			g.setStroke(stroke1);
			g.draw(new Ellipse2D.Double(x-5.0, y-5.0, 10.0, 10.0));
		}
	}
	
	static final Stroke stroke1 = new BasicStroke(1.0f);
	static final Stroke stroke3 = new BasicStroke(3.0f);
	static final Stroke stroke5 = new BasicStroke(5.0f);
	
	static void drawRectangle(Graphics2D g, double x0, double y0, double x1, double y1) {
		if(x0 > x1) {
			double temp = x0;
			x0 = x1;
			x1 = temp;
		}
		if(y0 > y1) {
			double temp = y0;
			y0 = y1;
			y1 = temp;
		}
		x0 += 5.0;
		y0 += 5.0;
		x1 -= 5.0;
		y1 -= 5.0;
		Rectangle2D rect = new Rectangle2D.Double(x0, y0, x1-x0, y1-y0);
		g.fill(rect);			
	}
	
	Image offScreenImage;
	int offScreenImageWidth;
	int offScreenImageHeight;

	public void update( Graphics g ) {
		if ( offScreenImage == null || getWidth() != offScreenImageWidth || getHeight() != offScreenImageHeight) {
			offScreenImageWidth = getWidth();
			offScreenImageHeight = getHeight();
			offScreenImage = createImage(offScreenImageWidth, offScreenImageHeight);
		}

		Graphics gOffScreenImage = offScreenImage.getGraphics();

		gOffScreenImage.clearRect(0, 0, getWidth(), getHeight());
		paint( gOffScreenImage );

		g.drawImage(offScreenImage, 0, 0, this);

		gOffScreenImage.dispose();
	} 
	
	public static void main(String[] args) {
		new TestRouter();
	}
	
}
