/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;

/**
 * Participant that enables grabbing of canvas.
 * 
 * @See {@link HandPainter} Paints grabbing of canvas
 * @author Toni Kalajainen
 */
public class CanvasGrab extends AbstractCanvasParticipant {

	@Dependency TransformUtil util;
	
    public Map<Integer, PointerInfo> grabInfo = new HashMap<Integer, PointerInfo>();
    
    public PointerInfo grabCanvas(int id, Point2D pos)
    {    	
    	PointerInfo result = new PointerInfo(pos, id);
        result.currentPos = pos;        
        grabInfo.put(id, result);        
    	return result;
    }
    
    public void releaseCanvas(int id)
    {
    	grabInfo.remove(id);
    }
	
    /** Info of pointers with left button down */
    public static final class PointerInfo {
        public final int mouseId;
        // Anchoring position in control coordinates 
        public Point2D anchorPos;
        public Point2D currentPos;
        public PointerInfo(Point2D anchorPos, int mouseId) {
            this.anchorPos = anchorPos;
            this.mouseId = mouseId;
        }       
    }
    
    public Map<Integer, PointerInfo> getGrabInfo()
    {
    	return grabInfo;
    }
	
}
