/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image;

 import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;

import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;

/**
 * Interface for paintable graphics - either vector or raster.
 * 
 * 
 * @See {@link ImageUtils} Image handling utilities
 * @author Toni Kalajainen
 */
public interface Image {
	
	/**
	 * Paint the image to a graphics 2d context.
	 * 
	 * @param g graphics context
	 */
	Node init(G2DParentNode parent);
    
	/**
	 * Get rectangle that contains the whole image.
	 * 
	 * @return bounds
	 */
	Rectangle2D getBounds();
	
	/**
	 * Get an outline of the image.
	 * 
	 * @return boundary of the image
	 */
	Shape getOutline();
	
	public enum Feature {
		Vector,		// Vector image, unlimited quality
		Volatile	// The content of the image may change
	}
	
	EnumSet<Feature> VECTOR = EnumSet.of(Feature.Vector);
	EnumSet<Feature> VOLATILE = EnumSet.of(Feature.Volatile);
	EnumSet<Feature> VOLATILE_VECTOR = EnumSet.of(Feature.Vector, Feature.Volatile);
	
	public EnumSet<Feature> getFeatures();
	
	public interface ImageListener {
		/**
		 * Notification signaling that the content (size, of content) 
		 * of an image has changed.
		 * This notification can occur only to images with Volatile feature. 
		 * 
		 * @param image
		 */
		void onContentChangedNotification(Image image);
	}
	
	/**
	 * Add image listener.  
	 * @param listener
	 */
	void addImageListener(ImageListener listener);
	
	/**
	 * Remove image listener
	 * @param listener
	 */
	void removeImageListener(ImageListener listener);
	
}
