/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.example.chassis;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.FullscreenUtils;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.example.TestCanvas;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * Full screen diagram example
 * 
 * Run this example with VM args: -Dsun.java2d.opengl=true
 * @author Toni Kalajainen
 */
public class FullscreenExample {

    public static void main(String[] args) {
        GraphicsDevice monitor = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();

        final IThreadWorkQueue  t   = AWTThread.getThreadAccess();
        final ICanvasContext    ctx = TestCanvas.createDefaultCanvas(t);
        final IDiagram          d   = TestCanvas.createMultilevelDiagram(ctx);
        ctx.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, d);
        Frame frame = FullscreenUtils.viewFullScreen(monitor, ctx);
        // Add a window listener for close button
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                d.dispose();
                ctx.dispose();
                System.exit(0);
            }
        });
    }

}
