/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementHints.Properties;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.PropertySetter;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

public class PlainElementPropertySetter implements PropertySetter {

    private static final long serialVersionUID = -3165827599737160621L;

    public static final PlainElementPropertySetter INSTANCE = new PlainElementPropertySetter(ElementHints.KEY_SG_NODE);
    public static final Key KEY_PROFILE_PROPERTIES = new KeyOf(Properties.class, "ELEMENT_PROFILE_PROPERTIES");
    private final Key key;

    public PlainElementPropertySetter(Key key) {
        this.key = key;
    }

    @Override
    public void overrideProperties(IElement e, Properties properties) {
        Properties profile = e.getHint(KEY_PROFILE_PROPERTIES);
        if(profile == null) {
            profile = new Properties();
            e.setHint(KEY_PROFILE_PROPERTIES, profile);
        }
        profile.clear();
        profile.putAll(properties);
    }

    @Override
    public void overrideProperty(IElement e, String name, Object value) {
        //System.out.println(name+"="+value);
        Properties profile = e.getHint(KEY_PROFILE_PROPERTIES);
        if(profile == null) {
            profile = new Properties();
            e.setHint(KEY_PROFILE_PROPERTIES, profile);
        }
        profile.put(name, value);
    }

    private Node findSingle(Node node, Class<?> clazz) {

//		System.err.println("findSingle " + node);

        if(clazz.isInstance(node)) return node;

        if(node instanceof G2DParentNode) {
            G2DParentNode parent = (G2DParentNode)node;
            Node found = null;
            for(IG2DNode child : parent.getNodes()) {
                if(child instanceof Node) {
                    Node test = findSingle((Node)child, clazz);
                    if(test != null) {
                        if(found == null) found = test;
                        else return null;
                    }
                }
            }
            return found;
        } else {
            return null;
        }

    }

    private Node findAnimatedNode(Node node) {
        Node animated = findSingle(node, AnimatedNode.class);
        if(animated != null) return animated;
        else return node;
    }

    @Override
    public void syncPropertiesToNode(IElement e) {
        Properties profile = e.getHint(KEY_PROFILE_PROPERTIES);
        Properties element = e.getHint(ElementHints.KEY_ELEMENT_PROPERTIES);

        Node node = e.getHint(this.key);
        if(node == null) return; // FIXME

        node = findAnimatedNode(node);

        Properties concat = new Properties();
        if(element != null) {
            for(String key : element.keySet()) {
                concat.put(key, element.get(key));
            }
        }

        if(profile != null) {
            for(String key : profile.keySet()) {
                concat.put(key, profile.get(key));
            }
        }

        for(String property : concat.keySet()) {
            //System.out.println("sync: "+property+" | "+concat.get(property));
            // TODO: property names containing dots "." should be splitted and treated as hierarchical properties 
            if(property.contains(".")) {
                String t[] = property.split("\\.");
                if(t.length == 2) { // FIXME: add support for deeper hierarchy
                    String child_name = t[0];
                    String property_name = t[1];
                    if(node instanceof G2DParentNode) {
                        INode child = NodeUtil.findChildById((G2DParentNode)node, child_name);
                        if(child != null)
                            NodeUtil.setPropertyIfSupported(property_name, concat.get(property), child);
                    }
                }
            } else {
                NodeUtil.setPropertyIfSupported(property, concat.get(property), node);
            }
        }
    }
}
