/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.impl;

import java.util.Map;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * @author Tuukka Lehtonen
 */
public class ProxyElement implements IElement {

    protected final IElement orig;

    public ProxyElement(IElement orig) {
        this.orig = orig;
    }

    @Override
    public void addedToDiagram(IDiagram diagram) {
        orig.addedToDiagram(diagram);
    }

    @Override
    public void destroy() {
        orig.destroy();
    }

    @Override
    public void dispose() {
        orig.dispose();
    }

    @Override
    public IDiagram getDiagram() {
        return orig.getDiagram();
    }

    @Override
    public ElementClass getElementClass() {
        return orig.getElementClass();
    }

    @Override
    public IDiagram peekDiagram() {
        return orig.peekDiagram();
    }

    @Override
    public <E> E removeHint(Key key) {
        return orig.removeHint(key);
    }

    @Override
    public void setHint(Key key, Object value) {
        orig.setHint(key, value);
    }

    @Override
    public void setHints(Map<Key, Object> hints) {
        orig.setHints(hints);
    }

    @Override
    public void addHintListener(IHintListener listener) {
        orig.addHintListener(listener);
    }

    @Override
    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        orig.addHintListener(threadAccess, listener);
    }

    @Override
    public void addKeyHintListener(Key key, IHintListener listener) {
        orig.addKeyHintListener(key, listener);
    }

    @Override
    public void addKeyHintListener(IThreadWorkQueue threadAccess, Key key, IHintListener listener) {
        orig.addKeyHintListener(threadAccess, key, listener);
    }

    @Override
    public void clearWithoutNotification() {
        orig.clearWithoutNotification();
    }

    @Override
    public boolean containsHint(Key key) {
        return orig.containsHint(key);
    }

    @Override
    public <E> E getHint(Key key) {
        return orig.getHint(key);
    }

    @Override
    public Map<Key, Object> getHints() {
        return orig.getHints();
    }

    @Override
    public Map<Key, Object> getHintsUnsafe() {
        return orig.getHintsUnsafe();
    }

    @Override
    public <E extends Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        return orig.getHintsOfClass(clazz);
    }

    @Override
    public void removeHintListener(IHintListener listener) {
        orig.removeHintListener(listener);
    }

    @Override
    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        orig.removeHintListener(threadAccess, listener);
    }

    @Override
    public void removeKeyHintListener(Key key, IHintListener listener) {
        orig.removeKeyHintListener(key, listener);
    }

    @Override
    public void removeKeyHintListener(IThreadWorkQueue threadAccess, Key key, IHintListener listener) {
        orig.removeKeyHintListener(threadAccess, key, listener);
    }

}
