/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.AffineTransform;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Transform;

/**
 * @author Toni Kalajainen
 */
public class ProxyTransform implements Transform {

    private static final long serialVersionUID = 4853914515925109674L;

    Transform                 orig;
    IProxyProvider            provider;

    public ProxyTransform(IProxyProvider provider, Transform orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public AffineTransform getTransform(IElement e) {
        return orig.getTransform(provider.provide(e));
    }

    @Override
    public void setTransform(IElement e, AffineTransform at) {
        orig.setTransform(provider.provide(e), at);
    }

}
