/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.Stroke;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;

/**
 * @author Toni Kalajainen
 */
public class ProxyEdgeVisuals implements EdgeVisuals {

	private static final long serialVersionUID = -2890966887731302696L;
	EdgeVisuals orig;
	IProxyProvider provider;
	
	public ProxyEdgeVisuals(IProxyProvider provider, EdgeVisuals orig) {
		this.provider = provider;
		this.orig = orig;
	}

	@Override
	public double getArrowSize(IElement e, EdgeEnd end) {
		return orig.getArrowSize(provider.provide(e), end);
	}

	@Override
	public ArrowType getArrowType(IElement e, EdgeEnd end) {
		return orig.getArrowType(provider.provide(e), end);
	}

    @Override
    public StrokeType getStrokeType(IElement e) {
        return orig.getStrokeType(provider.provide(e));
    }

	@Override
	public Stroke getStroke(IElement e) {
		return orig.getStroke(provider.provide(e));
	}

	@Override
	public void setArrowSize(IElement e, EdgeEnd end, double size) {
		orig.setArrowSize(provider.provide(e), end, size);
	}

    @Override
    public void setStrokeType(IElement e, StrokeType strokeType) {
        orig.setStrokeType(provider.provide(e), strokeType);
    }

	@Override
	public void setArrowType(IElement e, EdgeEnd end, ArrowType arrowType) {
		orig.setArrowType(provider.provide(e), end, arrowType);
	}

	@Override
	public void setStroke(IElement e, Stroke s) {
		orig.setStroke(provider.provide(e), s);
	}
	
}
