/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.utils.threads.IThreadWorkQueue;

/**
 * @author Toni Kalajainen
 */
public class ProxyClickable implements Clickable {

	private static final long serialVersionUID = 6971899752468214141L;
	Clickable orig;
	IProxyProvider provider;
	
	public ProxyClickable(IProxyProvider provider, Clickable orig) {
		this.provider = provider;
		this.orig = orig;
	}

	@Override
	public void addListener(IElement e, ICanvasContext ctx, IThreadWorkQueue ta, ClickListener listener) {
		orig.addListener(e, ctx, ta, listener);
	}

	@Override
	public PressStatus getPressStatus(IElement e, ICanvasContext ctx) {
		return orig.getPressStatus(e, ctx);
	}

	@Override
	public void removeListener(IElement e, ICanvasContext ctx, IThreadWorkQueue ta, ClickListener listener) {
		orig.removeListener(e, ctx, ta, listener);
	}	
	
}
