/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.AbstractClickable;
import org.simantics.g2d.element.handler.impl.AbstractGrabbable;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.MouseEvent;

/**
 * Handler that handles mouse events.
 * Coordinates are in element coordinate system.
 * <p>
 * Handler receives mouse enter and exit events when pointer
 * enters / exits the element area / control area. 
 * <p>
 * This handler requires that {@link ElementInteractor} in the canvas. 
 * 
 * @See {@link AbstractGrabbable} Base implementation for elements with draggable content
 * @See {@link AbstractClickable} Base implementation for elements that are pressable
 * 
 * @See {@link TransformUtil} Coordinate modifications
 * @author Toni Kalajainen
 */
public interface HandleMouseEvent extends ElementHandler {
	
	/** This handler consumes all mouse events sent to element */
	public static final HandleMouseEvent EVENT_CONSUMER = new HandleMouseEvent() {
		private static final long serialVersionUID = 8575435739682820291L;
		@Override
		public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
			return true;
		}
	};
	
	/**
	 * Handle mouse event. Coordinates are in control coordinates.
	 * @param e
	 * @return
	 */
	boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me);
	
}
