/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;

/**
 * This handler makes it possible to add adapters to different objects into an
 * {@link ElementClass}. An element can have multiple Adapter handlers. For
 * adaption, they are processed in the order of definition within the
 * {@link ElementClass} and adaption should return the first
 * <code>non-null</code> result returned by the any Adapter implementation.
 * 
 * <p>
 * See {@link ElementUtils#adapt(org.simantics.g2d.element.IElement, Class)} for
 * a utility that implements the above logic.
 * </p>
 * 
 * @author Tuukka Lehtonen
 * @see StaticObjectAdapter
 */
public interface Adapter extends ElementHandler {

    /**
     * @return
     */
    <T> T adapt(Class<T> toClass);

}