/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.connection;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;

/**
 * @author Hannu Niemisto
 */
public interface IConnectionAdvisor {

    /**
     * @param backend current backend data access object or <code>null</code> if
     *        there's no ongoing transaction
     * @param element1
     * @param term1
     * @param element2
     * @param term2
     * @return a back-end object that describes the type of the connection that
     *         would be created if the two terminals were connected. If
     *         <code>null</code> is returned, connection is not to be allowed.
     *         Otherwise the tools will allow the connection to proceed,
     *         regardless of whether the connection is in reality sane or not.
     *         It is the job of the {@link IConnectionAdvisor} to verify this,
     *         not the tool's.
     * 
     * @see ElementHints#KEY_CONNECTION_TYPE
     */
    Object canBeConnected(Object backend, IElement element1, Terminal term1, IElement element2, Terminal term2);

    /**
     * @param backend current backend data access object or <code>null</code> if
     *        there's no ongoing transaction
     * @param element
     * @param term
     * @return
     */
    boolean canBeginConnection(Object backend, IElement element, Terminal term);

}
