package org.simantics.export.core.manager;

import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;

/**
 * A single article of export action in an export plan.
 *
 * @author toni.kalajainen@semantum.fi
 */
public abstract class ExportAction {
	
	/**
	 * Execute export action.
	 * 
	 * @param ctx
	 * @param progress
	 * @param options
	 * @throws ExportException
	 */
	public abstract void execute(ExportContext ctx, IProgressMonitor progress, Variant options)
			throws ExportException;
	
	/**
	 * Get the label for this action to be used in user interface.
	 * 
	 * @param ctx
	 * @return the label for this action.
	 */
	public abstract String label(ExportContext ctx);
	
	/**
	 * Get the amount of work in this action (used in progress bar).
	 * 
	 * @param ctx
	 * @return the amount of work
	 */
	public abstract int work(ExportContext ctx);
	
	/**
	 * Validate action is executable
	 * 
	 * @param ctx
	 * @param options
	 * @return null or a label describing the expected problem
	 */
	public abstract List<String> validate(ExportContext ctx, Variant options);
	
	/**
	 * Cancel and cleanup the output of this action. Deletes temporary files. 
	 * 
	 * @param ctx
	 * @param progress
	 * @param options
	 * @throws ExportException
	 */
	public abstract void cleanup(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException;
	
}
