/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.contribution;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.GraphImageDescriptor;
import org.simantics.viewpoint.ontology.ViewpointResource;

/**
 * @author Tuukka Lehtonen
 */
public class EventTypeImageDescriptorRequest extends ResourceRead<ImageDescriptor> {

    public EventTypeImageDescriptorRequest(Resource eventType) {
        super(eventType);
    }

    @Override
    public ImageDescriptor perform(ReadGraph graph) throws DatabaseException {
        ViewpointResource VP = ViewpointResource.getInstance(graph);
        Resource image = graph.getPossibleObject(resource, VP.ConstantImageRule_HasImage);
        if (image == null)
            return null;
        return new GraphImageDescriptor(graph, image);
    }

}