/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenEntityDocumentAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.document.ui.editor";

    public OpenEntityDocumentAdapter() throws MalformedURLException {
        super("Document Editor", ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.famfamfam.silk/icons/table.png")));
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, Layer0.getInstance((ReadGraph)g).Entity);
    }

    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                final Resource rr = OpenEntityDocumentAdapter.this.getActualResource(graph, r);
                Variable variable = (Variable)graph.adapt(rr, Variable.class);
                final Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
                final RVI rvi = variable.getRVI(graph);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String editorId = OpenEntityDocumentAdapter.this.getEditorId();
                            if (rvi != null) {
                                WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, rr, model, rvi));
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    protected Resource getActualResource(ReadGraph graph, Resource r) {
        return r;
    }
}

