/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.dialogs;

import java.io.File;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.utils.ui.validators.FileNameValidator;

/**
 * Dialog for adding URL links with additional information
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class FileDetailDialog extends TextInputDialog{

	private String fileName;
	private String name;
	
	Text fileText;
	Text nameText;
	
	IInputValidator fileValidator;
	IInputValidator nameValidator;
	
	Composite annotationComposite;
	
	AnnotationConfigurator annotationConfigurator;
	
	public FileDetailDialog(Shell parentShell, Resource lib) {
		super(parentShell);
		try {
			annotationConfigurator = new AnnotationConfigurator(DocumentResource.getInstance(Simantics.getSession()).FileDocument,lib);
		} catch (DatabaseException e) {
			
		}
	}
	
	public String getFileName() {
		return fileName;
	}
	
	public String getName() {
		return name;
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout(3,false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		composite.setLayout(layout);
		GridDataFactory.fillDefaults().hint(500, 500).applyTo(composite);
		
		Label label = new Label(composite, SWT.NONE);
		label.setText("File:");
		fileText = new Text(composite, SWT.SINGLE|SWT.BORDER);
		Button browseButton = new Button(composite, SWT.PUSH);
		browseButton.setText("Browse");
		label = new Label(composite, SWT.NONE);
		label.setText("Name:");
		nameText = new Text(composite, SWT.SINGLE|SWT.BORDER);
		label = new Label(composite, SWT.NONE);
		label = new Label(composite, SWT.NONE);
		label.setText("Annotations:");
		annotationComposite = new Composite(composite, SWT.NONE);
		annotationComposite.setLayout(new FillLayout());
		
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(true, false).applyTo(fileText);
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.CENTER).grab(true, false).applyTo(nameText);
		GridDataFactory.fillDefaults().align(SWT.FILL, SWT.FILL).grab(true, true).applyTo(annotationComposite);
		
		fileValidator = new FileNameValidator();
		
		fileText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if (validate(fileText, fileValidator)) {
					fileName = fileText.getText();
					updateName();
				}
			}
		});
		
		nameText.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				if (validate(nameText,nameValidator)) {
					name = nameText.getText();
				}
				
			}
		});
		
		browseButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(e.display.getActiveShell(),SWT.OPEN);
				dialog.setFilterExtensions(new String[]{"*.*"});
				String s = dialog.open();
				if (s != null) {
					name = null;
					fileText.setText(s);
				}
			}
		});
		
		annotationConfigurator.createComposite(annotationComposite);
		
		return composite;
	}
	
	private void updateName() {
		if (fileName.length() > 0) {
			String proposal = new File(fileName).getName();
			String newName = updateName(proposal, name);
			if (newName != null) {
				name = newName;
				nameText.setText(name);
			}
		}
	}
	
	public void setNameValidator(IInputValidator nameValidator) {
		this.nameValidator = nameValidator;
	}
	
	public AnnotationConfigurator getAnnotationConfigurator() {
		return annotationConfigurator;
	}
	

}
