package org.simantics.document.swt.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SWTResources {
    
    public final Resource Components;
    public final Resource Components_Browser;
    public final Resource Components_Browser_url;
    public final Resource Components_Browser_url_Inverse;
    public final Resource Components_Button;
    public final Resource Components_Button_onPress;
    public final Resource Components_Button_onPress_Inverse;
    public final Resource Components_Button_text;
    public final Resource Components_Button_text_Inverse;
    public final Resource Components_Combo;
    public final Resource Components_Combo_available;
    public final Resource Components_Combo_available_Inverse;
    public final Resource Components_Combo_onModify;
    public final Resource Components_Combo_onModify_Inverse;
    public final Resource Components_Combo_selected;
    public final Resource Components_Combo_selected_Inverse;
    public final Resource Components_Component;
    public final Resource Components_Component_HScroll;
    public final Resource Components_Component_HScroll_Inverse;
    public final Resource Components_Component_NoScroll;
    public final Resource Components_Component_NoScroll_Inverse;
    public final Resource Components_Component_VScroll;
    public final Resource Components_Component_VScroll_Inverse;
    public final Resource Components_Component_alignment;
    public final Resource Components_Component_alignment_Inverse;
    public final Resource Components_Component_background;
    public final Resource Components_Component_background_Inverse;
    public final Resource Components_Component_font;
    public final Resource Components_Component_font_Inverse;
    public final Resource Components_Component_foreground;
    public final Resource Components_Component_foreground_Inverse;
    public final Resource Components_Component_multiLine;
    public final Resource Components_Component_multiLine_Inverse;
    public final Resource Components_Explorer;
    public final Resource Components_Explorer_browseContext;
    public final Resource Components_Explorer_browseContext_Inverse;
    public final Resource Components_Explorer_columns;
    public final Resource Components_Explorer_columns_Inverse;
    public final Resource Components_Explorer_contextMenuId;
    public final Resource Components_Explorer_contextMenuId_Inverse;
    public final Resource Components_Explorer_displayFilter;
    public final Resource Components_Explorer_displayFilter_Inverse;
    public final Resource Components_Explorer_displayHeader;
    public final Resource Components_Explorer_displayHeader_Inverse;
    public final Resource Components_Explorer_dragSourceListenerFactory;
    public final Resource Components_Explorer_dragSourceListenerFactory_Inverse;
    public final Resource Components_Explorer_editingColumn;
    public final Resource Components_Explorer_editingColumn_Inverse;
    public final Resource Components_Explorer_explorerInput;
    public final Resource Components_Explorer_explorerInput_Inverse;
    public final Resource Components_GridCell;
    public final Resource Components_GridCell_grabHorizontal;
    public final Resource Components_GridCell_grabHorizontal_Inverse;
    public final Resource Components_GridCell_grabVertical;
    public final Resource Components_GridCell_grabVertical_Inverse;
    public final Resource Components_GridCell_span;
    public final Resource Components_GridCell_span_Inverse;
    public final Resource Components_GridComposite;
    public final Resource Components_GridComposite_extendedMargins;
    public final Resource Components_GridComposite_extendedMargins_Inverse;
    public final Resource Components_GridComposite_numColumns;
    public final Resource Components_GridComposite_numColumns_Inverse;
    public final Resource Components_Label;
    public final Resource Components_Label_text;
    public final Resource Components_Label_text_Inverse;
    public final Resource Components_SCLTextEditor;
    public final Resource Components_SCLTextEditor_onModify;
    public final Resource Components_SCLTextEditor_onModify_Inverse;
    public final Resource Components_SCLTextEditor_textAndErrors;
    public final Resource Components_SCLTextEditor_textAndErrors_Inverse;
    public final Resource Components_ScrolledComposite;
    public final Resource Components_TrackedText;
    public final Resource Components_TrackedText_editingBackground;
    public final Resource Components_TrackedText_editingBackground_Inverse;
    public final Resource Components_TrackedText_hoverBackground;
    public final Resource Components_TrackedText_hoverBackground_Inverse;
    public final Resource Components_TrackedText_inactiveBackground;
    public final Resource Components_TrackedText_inactiveBackground_Inverse;
    public final Resource Components_TrackedText_invalidBackground;
    public final Resource Components_TrackedText_invalidBackground_Inverse;
    public final Resource Components_TrackedText_onModify;
    public final Resource Components_TrackedText_onModify_Inverse;
    public final Resource Components_TrackedText_text;
    public final Resource Components_TrackedText_text_Inverse;
    public final Resource Components_TrackedText_validator;
    public final Resource Components_TrackedText_validator_Inverse;
    public final Resource Components_attribute;
    public final Resource Functions;
    public final Resource Functions_explorerInput;
    public final Resource Functions_input;
    public final Resource Functions_propertyDisplayValue;
    public final Resource Functions_propertyDisplayValueModifier;
    public final Resource Literals;
    public final Resource Literals_Columns;
    public final Resource Literals_Margins;
    public final Resource Properties;
    public final Resource Properties_ParameterType;
    public final Resource Properties_ParameterType_sclValueProperty;
    public final Resource Properties_ParameterType_sclValueProperty_Inverse;
    public final Resource SCLMain;
    public final Resource TypedVariableTabContribution;
    public final Resource TypedVariableTabContribution_HasView;
    public final Resource TypedVariableTabContribution_HasView_Inverse;
    public final Resource TypedVariableTabContribution_type;
    public final Resource TypedVariableTabContribution_type_Inverse;
    public final Resource button;
    public final Resource combo;
    public final Resource connect;
    public final Resource defAttribute;
    public final Resource explorer;
    public final Resource gridCell;
    public final Resource gridComposite;
    public final Resource label;
    public final Resource sclTextEditor;
    public final Resource scrolledComposite;
    public final Resource trackedText;
        
    public static class URIs {
        public static final String Components = "http://www.simantics.org/SWT-1.0/Components";
        public static final String Components_Browser = "http://www.simantics.org/SWT-1.0/Components/Browser";
        public static final String Components_Browser_url = "http://www.simantics.org/SWT-1.0/Components/Browser/url";
        public static final String Components_Browser_url_Inverse = "http://www.simantics.org/SWT-1.0/Components/Browser/url/Inverse";
        public static final String Components_Button = "http://www.simantics.org/SWT-1.0/Components/Button";
        public static final String Components_Button_onPress = "http://www.simantics.org/SWT-1.0/Components/Button/onPress";
        public static final String Components_Button_onPress_Inverse = "http://www.simantics.org/SWT-1.0/Components/Button/onPress/Inverse";
        public static final String Components_Button_text = "http://www.simantics.org/SWT-1.0/Components/Button/text";
        public static final String Components_Button_text_Inverse = "http://www.simantics.org/SWT-1.0/Components/Button/text/Inverse";
        public static final String Components_Combo = "http://www.simantics.org/SWT-1.0/Components/Combo";
        public static final String Components_Combo_available = "http://www.simantics.org/SWT-1.0/Components/Combo/available";
        public static final String Components_Combo_available_Inverse = "http://www.simantics.org/SWT-1.0/Components/Combo/available/Inverse";
        public static final String Components_Combo_onModify = "http://www.simantics.org/SWT-1.0/Components/Combo/onModify";
        public static final String Components_Combo_onModify_Inverse = "http://www.simantics.org/SWT-1.0/Components/Combo/onModify/Inverse";
        public static final String Components_Combo_selected = "http://www.simantics.org/SWT-1.0/Components/Combo/selected";
        public static final String Components_Combo_selected_Inverse = "http://www.simantics.org/SWT-1.0/Components/Combo/selected/Inverse";
        public static final String Components_Component = "http://www.simantics.org/SWT-1.0/Components/Component";
        public static final String Components_Component_HScroll = "http://www.simantics.org/SWT-1.0/Components/Component/HScroll";
        public static final String Components_Component_HScroll_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/HScroll/Inverse";
        public static final String Components_Component_NoScroll = "http://www.simantics.org/SWT-1.0/Components/Component/NoScroll";
        public static final String Components_Component_NoScroll_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/NoScroll/Inverse";
        public static final String Components_Component_VScroll = "http://www.simantics.org/SWT-1.0/Components/Component/VScroll";
        public static final String Components_Component_VScroll_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/VScroll/Inverse";
        public static final String Components_Component_alignment = "http://www.simantics.org/SWT-1.0/Components/Component/alignment";
        public static final String Components_Component_alignment_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/alignment/Inverse";
        public static final String Components_Component_background = "http://www.simantics.org/SWT-1.0/Components/Component/background";
        public static final String Components_Component_background_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/background/Inverse";
        public static final String Components_Component_font = "http://www.simantics.org/SWT-1.0/Components/Component/font";
        public static final String Components_Component_font_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/font/Inverse";
        public static final String Components_Component_foreground = "http://www.simantics.org/SWT-1.0/Components/Component/foreground";
        public static final String Components_Component_foreground_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/foreground/Inverse";
        public static final String Components_Component_multiLine = "http://www.simantics.org/SWT-1.0/Components/Component/multiLine";
        public static final String Components_Component_multiLine_Inverse = "http://www.simantics.org/SWT-1.0/Components/Component/multiLine/Inverse";
        public static final String Components_Explorer = "http://www.simantics.org/SWT-1.0/Components/Explorer";
        public static final String Components_Explorer_browseContext = "http://www.simantics.org/SWT-1.0/Components/Explorer/browseContext";
        public static final String Components_Explorer_browseContext_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/browseContext/Inverse";
        public static final String Components_Explorer_columns = "http://www.simantics.org/SWT-1.0/Components/Explorer/columns";
        public static final String Components_Explorer_columns_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/columns/Inverse";
        public static final String Components_Explorer_contextMenuId = "http://www.simantics.org/SWT-1.0/Components/Explorer/contextMenuId";
        public static final String Components_Explorer_contextMenuId_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/contextMenuId/Inverse";
        public static final String Components_Explorer_displayFilter = "http://www.simantics.org/SWT-1.0/Components/Explorer/displayFilter";
        public static final String Components_Explorer_displayFilter_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/displayFilter/Inverse";
        public static final String Components_Explorer_displayHeader = "http://www.simantics.org/SWT-1.0/Components/Explorer/displayHeader";
        public static final String Components_Explorer_displayHeader_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/displayHeader/Inverse";
        public static final String Components_Explorer_dragSourceListenerFactory = "http://www.simantics.org/SWT-1.0/Components/Explorer/dragSourceListenerFactory";
        public static final String Components_Explorer_dragSourceListenerFactory_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/dragSourceListenerFactory/Inverse";
        public static final String Components_Explorer_editingColumn = "http://www.simantics.org/SWT-1.0/Components/Explorer/editingColumn";
        public static final String Components_Explorer_editingColumn_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/editingColumn/Inverse";
        public static final String Components_Explorer_explorerInput = "http://www.simantics.org/SWT-1.0/Components/Explorer/explorerInput";
        public static final String Components_Explorer_explorerInput_Inverse = "http://www.simantics.org/SWT-1.0/Components/Explorer/explorerInput/Inverse";
        public static final String Components_GridCell = "http://www.simantics.org/SWT-1.0/Components/GridCell";
        public static final String Components_GridCell_grabHorizontal = "http://www.simantics.org/SWT-1.0/Components/GridCell/grabHorizontal";
        public static final String Components_GridCell_grabHorizontal_Inverse = "http://www.simantics.org/SWT-1.0/Components/GridCell/grabHorizontal/Inverse";
        public static final String Components_GridCell_grabVertical = "http://www.simantics.org/SWT-1.0/Components/GridCell/grabVertical";
        public static final String Components_GridCell_grabVertical_Inverse = "http://www.simantics.org/SWT-1.0/Components/GridCell/grabVertical/Inverse";
        public static final String Components_GridCell_span = "http://www.simantics.org/SWT-1.0/Components/GridCell/span";
        public static final String Components_GridCell_span_Inverse = "http://www.simantics.org/SWT-1.0/Components/GridCell/span/Inverse";
        public static final String Components_GridComposite = "http://www.simantics.org/SWT-1.0/Components/GridComposite";
        public static final String Components_GridComposite_extendedMargins = "http://www.simantics.org/SWT-1.0/Components/GridComposite/extendedMargins";
        public static final String Components_GridComposite_extendedMargins_Inverse = "http://www.simantics.org/SWT-1.0/Components/GridComposite/extendedMargins/Inverse";
        public static final String Components_GridComposite_numColumns = "http://www.simantics.org/SWT-1.0/Components/GridComposite/numColumns";
        public static final String Components_GridComposite_numColumns_Inverse = "http://www.simantics.org/SWT-1.0/Components/GridComposite/numColumns/Inverse";
        public static final String Components_Label = "http://www.simantics.org/SWT-1.0/Components/Label";
        public static final String Components_Label_text = "http://www.simantics.org/SWT-1.0/Components/Label/text";
        public static final String Components_Label_text_Inverse = "http://www.simantics.org/SWT-1.0/Components/Label/text/Inverse";
        public static final String Components_SCLTextEditor = "http://www.simantics.org/SWT-1.0/Components/SCLTextEditor";
        public static final String Components_SCLTextEditor_onModify = "http://www.simantics.org/SWT-1.0/Components/SCLTextEditor/onModify";
        public static final String Components_SCLTextEditor_onModify_Inverse = "http://www.simantics.org/SWT-1.0/Components/SCLTextEditor/onModify/Inverse";
        public static final String Components_SCLTextEditor_textAndErrors = "http://www.simantics.org/SWT-1.0/Components/SCLTextEditor/textAndErrors";
        public static final String Components_SCLTextEditor_textAndErrors_Inverse = "http://www.simantics.org/SWT-1.0/Components/SCLTextEditor/textAndErrors/Inverse";
        public static final String Components_ScrolledComposite = "http://www.simantics.org/SWT-1.0/Components/ScrolledComposite";
        public static final String Components_TrackedText = "http://www.simantics.org/SWT-1.0/Components/TrackedText";
        public static final String Components_TrackedText_editingBackground = "http://www.simantics.org/SWT-1.0/Components/TrackedText/editingBackground";
        public static final String Components_TrackedText_editingBackground_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/editingBackground/Inverse";
        public static final String Components_TrackedText_hoverBackground = "http://www.simantics.org/SWT-1.0/Components/TrackedText/hoverBackground";
        public static final String Components_TrackedText_hoverBackground_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/hoverBackground/Inverse";
        public static final String Components_TrackedText_inactiveBackground = "http://www.simantics.org/SWT-1.0/Components/TrackedText/inactiveBackground";
        public static final String Components_TrackedText_inactiveBackground_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/inactiveBackground/Inverse";
        public static final String Components_TrackedText_invalidBackground = "http://www.simantics.org/SWT-1.0/Components/TrackedText/invalidBackground";
        public static final String Components_TrackedText_invalidBackground_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/invalidBackground/Inverse";
        public static final String Components_TrackedText_onModify = "http://www.simantics.org/SWT-1.0/Components/TrackedText/onModify";
        public static final String Components_TrackedText_onModify_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/onModify/Inverse";
        public static final String Components_TrackedText_text = "http://www.simantics.org/SWT-1.0/Components/TrackedText/text";
        public static final String Components_TrackedText_text_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/text/Inverse";
        public static final String Components_TrackedText_validator = "http://www.simantics.org/SWT-1.0/Components/TrackedText/validator";
        public static final String Components_TrackedText_validator_Inverse = "http://www.simantics.org/SWT-1.0/Components/TrackedText/validator/Inverse";
        public static final String Components_attribute = "http://www.simantics.org/SWT-1.0/Components/attribute";
        public static final String Functions = "http://www.simantics.org/SWT-1.0/Functions";
        public static final String Functions_explorerInput = "http://www.simantics.org/SWT-1.0/Functions/explorerInput";
        public static final String Functions_input = "http://www.simantics.org/SWT-1.0/Functions/input";
        public static final String Functions_propertyDisplayValue = "http://www.simantics.org/SWT-1.0/Functions/propertyDisplayValue";
        public static final String Functions_propertyDisplayValueModifier = "http://www.simantics.org/SWT-1.0/Functions/propertyDisplayValueModifier";
        public static final String Literals = "http://www.simantics.org/SWT-1.0/Literals";
        public static final String Literals_Columns = "http://www.simantics.org/SWT-1.0/Literals/Columns";
        public static final String Literals_Margins = "http://www.simantics.org/SWT-1.0/Literals/Margins";
        public static final String Properties = "http://www.simantics.org/SWT-1.0/Properties";
        public static final String Properties_ParameterType = "http://www.simantics.org/SWT-1.0/Properties/ParameterType";
        public static final String Properties_ParameterType_sclValueProperty = "http://www.simantics.org/SWT-1.0/Properties/ParameterType/sclValueProperty";
        public static final String Properties_ParameterType_sclValueProperty_Inverse = "http://www.simantics.org/SWT-1.0/Properties/ParameterType/sclValueProperty/Inverse";
        public static final String SCLMain = "http://www.simantics.org/SWT-1.0/SCLMain";
        public static final String TypedVariableTabContribution = "http://www.simantics.org/SWT-1.0/TypedVariableTabContribution";
        public static final String TypedVariableTabContribution_HasView = "http://www.simantics.org/SWT-1.0/TypedVariableTabContribution/HasView";
        public static final String TypedVariableTabContribution_HasView_Inverse = "http://www.simantics.org/SWT-1.0/TypedVariableTabContribution/HasView/Inverse";
        public static final String TypedVariableTabContribution_type = "http://www.simantics.org/SWT-1.0/TypedVariableTabContribution/type";
        public static final String TypedVariableTabContribution_type_Inverse = "http://www.simantics.org/SWT-1.0/TypedVariableTabContribution/type/Inverse";
        public static final String button = "http://www.simantics.org/SWT-1.0/button";
        public static final String combo = "http://www.simantics.org/SWT-1.0/combo";
        public static final String connect = "http://www.simantics.org/SWT-1.0/connect";
        public static final String defAttribute = "http://www.simantics.org/SWT-1.0/defAttribute";
        public static final String explorer = "http://www.simantics.org/SWT-1.0/explorer";
        public static final String gridCell = "http://www.simantics.org/SWT-1.0/gridCell";
        public static final String gridComposite = "http://www.simantics.org/SWT-1.0/gridComposite";
        public static final String label = "http://www.simantics.org/SWT-1.0/label";
        public static final String sclTextEditor = "http://www.simantics.org/SWT-1.0/sclTextEditor";
        public static final String scrolledComposite = "http://www.simantics.org/SWT-1.0/scrolledComposite";
        public static final String trackedText = "http://www.simantics.org/SWT-1.0/trackedText";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SWTResources(ReadGraph graph) {
        Components = getResourceOrNull(graph, URIs.Components);
        Components_Browser = getResourceOrNull(graph, URIs.Components_Browser);
        Components_Browser_url = getResourceOrNull(graph, URIs.Components_Browser_url);
        Components_Browser_url_Inverse = getResourceOrNull(graph, URIs.Components_Browser_url_Inverse);
        Components_Button = getResourceOrNull(graph, URIs.Components_Button);
        Components_Button_onPress = getResourceOrNull(graph, URIs.Components_Button_onPress);
        Components_Button_onPress_Inverse = getResourceOrNull(graph, URIs.Components_Button_onPress_Inverse);
        Components_Button_text = getResourceOrNull(graph, URIs.Components_Button_text);
        Components_Button_text_Inverse = getResourceOrNull(graph, URIs.Components_Button_text_Inverse);
        Components_Combo = getResourceOrNull(graph, URIs.Components_Combo);
        Components_Combo_available = getResourceOrNull(graph, URIs.Components_Combo_available);
        Components_Combo_available_Inverse = getResourceOrNull(graph, URIs.Components_Combo_available_Inverse);
        Components_Combo_onModify = getResourceOrNull(graph, URIs.Components_Combo_onModify);
        Components_Combo_onModify_Inverse = getResourceOrNull(graph, URIs.Components_Combo_onModify_Inverse);
        Components_Combo_selected = getResourceOrNull(graph, URIs.Components_Combo_selected);
        Components_Combo_selected_Inverse = getResourceOrNull(graph, URIs.Components_Combo_selected_Inverse);
        Components_Component = getResourceOrNull(graph, URIs.Components_Component);
        Components_Component_HScroll = getResourceOrNull(graph, URIs.Components_Component_HScroll);
        Components_Component_HScroll_Inverse = getResourceOrNull(graph, URIs.Components_Component_HScroll_Inverse);
        Components_Component_NoScroll = getResourceOrNull(graph, URIs.Components_Component_NoScroll);
        Components_Component_NoScroll_Inverse = getResourceOrNull(graph, URIs.Components_Component_NoScroll_Inverse);
        Components_Component_VScroll = getResourceOrNull(graph, URIs.Components_Component_VScroll);
        Components_Component_VScroll_Inverse = getResourceOrNull(graph, URIs.Components_Component_VScroll_Inverse);
        Components_Component_alignment = getResourceOrNull(graph, URIs.Components_Component_alignment);
        Components_Component_alignment_Inverse = getResourceOrNull(graph, URIs.Components_Component_alignment_Inverse);
        Components_Component_background = getResourceOrNull(graph, URIs.Components_Component_background);
        Components_Component_background_Inverse = getResourceOrNull(graph, URIs.Components_Component_background_Inverse);
        Components_Component_font = getResourceOrNull(graph, URIs.Components_Component_font);
        Components_Component_font_Inverse = getResourceOrNull(graph, URIs.Components_Component_font_Inverse);
        Components_Component_foreground = getResourceOrNull(graph, URIs.Components_Component_foreground);
        Components_Component_foreground_Inverse = getResourceOrNull(graph, URIs.Components_Component_foreground_Inverse);
        Components_Component_multiLine = getResourceOrNull(graph, URIs.Components_Component_multiLine);
        Components_Component_multiLine_Inverse = getResourceOrNull(graph, URIs.Components_Component_multiLine_Inverse);
        Components_Explorer = getResourceOrNull(graph, URIs.Components_Explorer);
        Components_Explorer_browseContext = getResourceOrNull(graph, URIs.Components_Explorer_browseContext);
        Components_Explorer_browseContext_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_browseContext_Inverse);
        Components_Explorer_columns = getResourceOrNull(graph, URIs.Components_Explorer_columns);
        Components_Explorer_columns_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_columns_Inverse);
        Components_Explorer_contextMenuId = getResourceOrNull(graph, URIs.Components_Explorer_contextMenuId);
        Components_Explorer_contextMenuId_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_contextMenuId_Inverse);
        Components_Explorer_displayFilter = getResourceOrNull(graph, URIs.Components_Explorer_displayFilter);
        Components_Explorer_displayFilter_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_displayFilter_Inverse);
        Components_Explorer_displayHeader = getResourceOrNull(graph, URIs.Components_Explorer_displayHeader);
        Components_Explorer_displayHeader_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_displayHeader_Inverse);
        Components_Explorer_dragSourceListenerFactory = getResourceOrNull(graph, URIs.Components_Explorer_dragSourceListenerFactory);
        Components_Explorer_dragSourceListenerFactory_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_dragSourceListenerFactory_Inverse);
        Components_Explorer_editingColumn = getResourceOrNull(graph, URIs.Components_Explorer_editingColumn);
        Components_Explorer_editingColumn_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_editingColumn_Inverse);
        Components_Explorer_explorerInput = getResourceOrNull(graph, URIs.Components_Explorer_explorerInput);
        Components_Explorer_explorerInput_Inverse = getResourceOrNull(graph, URIs.Components_Explorer_explorerInput_Inverse);
        Components_GridCell = getResourceOrNull(graph, URIs.Components_GridCell);
        Components_GridCell_grabHorizontal = getResourceOrNull(graph, URIs.Components_GridCell_grabHorizontal);
        Components_GridCell_grabHorizontal_Inverse = getResourceOrNull(graph, URIs.Components_GridCell_grabHorizontal_Inverse);
        Components_GridCell_grabVertical = getResourceOrNull(graph, URIs.Components_GridCell_grabVertical);
        Components_GridCell_grabVertical_Inverse = getResourceOrNull(graph, URIs.Components_GridCell_grabVertical_Inverse);
        Components_GridCell_span = getResourceOrNull(graph, URIs.Components_GridCell_span);
        Components_GridCell_span_Inverse = getResourceOrNull(graph, URIs.Components_GridCell_span_Inverse);
        Components_GridComposite = getResourceOrNull(graph, URIs.Components_GridComposite);
        Components_GridComposite_extendedMargins = getResourceOrNull(graph, URIs.Components_GridComposite_extendedMargins);
        Components_GridComposite_extendedMargins_Inverse = getResourceOrNull(graph, URIs.Components_GridComposite_extendedMargins_Inverse);
        Components_GridComposite_numColumns = getResourceOrNull(graph, URIs.Components_GridComposite_numColumns);
        Components_GridComposite_numColumns_Inverse = getResourceOrNull(graph, URIs.Components_GridComposite_numColumns_Inverse);
        Components_Label = getResourceOrNull(graph, URIs.Components_Label);
        Components_Label_text = getResourceOrNull(graph, URIs.Components_Label_text);
        Components_Label_text_Inverse = getResourceOrNull(graph, URIs.Components_Label_text_Inverse);
        Components_SCLTextEditor = getResourceOrNull(graph, URIs.Components_SCLTextEditor);
        Components_SCLTextEditor_onModify = getResourceOrNull(graph, URIs.Components_SCLTextEditor_onModify);
        Components_SCLTextEditor_onModify_Inverse = getResourceOrNull(graph, URIs.Components_SCLTextEditor_onModify_Inverse);
        Components_SCLTextEditor_textAndErrors = getResourceOrNull(graph, URIs.Components_SCLTextEditor_textAndErrors);
        Components_SCLTextEditor_textAndErrors_Inverse = getResourceOrNull(graph, URIs.Components_SCLTextEditor_textAndErrors_Inverse);
        Components_ScrolledComposite = getResourceOrNull(graph, URIs.Components_ScrolledComposite);
        Components_TrackedText = getResourceOrNull(graph, URIs.Components_TrackedText);
        Components_TrackedText_editingBackground = getResourceOrNull(graph, URIs.Components_TrackedText_editingBackground);
        Components_TrackedText_editingBackground_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_editingBackground_Inverse);
        Components_TrackedText_hoverBackground = getResourceOrNull(graph, URIs.Components_TrackedText_hoverBackground);
        Components_TrackedText_hoverBackground_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_hoverBackground_Inverse);
        Components_TrackedText_inactiveBackground = getResourceOrNull(graph, URIs.Components_TrackedText_inactiveBackground);
        Components_TrackedText_inactiveBackground_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_inactiveBackground_Inverse);
        Components_TrackedText_invalidBackground = getResourceOrNull(graph, URIs.Components_TrackedText_invalidBackground);
        Components_TrackedText_invalidBackground_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_invalidBackground_Inverse);
        Components_TrackedText_onModify = getResourceOrNull(graph, URIs.Components_TrackedText_onModify);
        Components_TrackedText_onModify_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_onModify_Inverse);
        Components_TrackedText_text = getResourceOrNull(graph, URIs.Components_TrackedText_text);
        Components_TrackedText_text_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_text_Inverse);
        Components_TrackedText_validator = getResourceOrNull(graph, URIs.Components_TrackedText_validator);
        Components_TrackedText_validator_Inverse = getResourceOrNull(graph, URIs.Components_TrackedText_validator_Inverse);
        Components_attribute = getResourceOrNull(graph, URIs.Components_attribute);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_explorerInput = getResourceOrNull(graph, URIs.Functions_explorerInput);
        Functions_input = getResourceOrNull(graph, URIs.Functions_input);
        Functions_propertyDisplayValue = getResourceOrNull(graph, URIs.Functions_propertyDisplayValue);
        Functions_propertyDisplayValueModifier = getResourceOrNull(graph, URIs.Functions_propertyDisplayValueModifier);
        Literals = getResourceOrNull(graph, URIs.Literals);
        Literals_Columns = getResourceOrNull(graph, URIs.Literals_Columns);
        Literals_Margins = getResourceOrNull(graph, URIs.Literals_Margins);
        Properties = getResourceOrNull(graph, URIs.Properties);
        Properties_ParameterType = getResourceOrNull(graph, URIs.Properties_ParameterType);
        Properties_ParameterType_sclValueProperty = getResourceOrNull(graph, URIs.Properties_ParameterType_sclValueProperty);
        Properties_ParameterType_sclValueProperty_Inverse = getResourceOrNull(graph, URIs.Properties_ParameterType_sclValueProperty_Inverse);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        TypedVariableTabContribution = getResourceOrNull(graph, URIs.TypedVariableTabContribution);
        TypedVariableTabContribution_HasView = getResourceOrNull(graph, URIs.TypedVariableTabContribution_HasView);
        TypedVariableTabContribution_HasView_Inverse = getResourceOrNull(graph, URIs.TypedVariableTabContribution_HasView_Inverse);
        TypedVariableTabContribution_type = getResourceOrNull(graph, URIs.TypedVariableTabContribution_type);
        TypedVariableTabContribution_type_Inverse = getResourceOrNull(graph, URIs.TypedVariableTabContribution_type_Inverse);
        button = getResourceOrNull(graph, URIs.button);
        combo = getResourceOrNull(graph, URIs.combo);
        connect = getResourceOrNull(graph, URIs.connect);
        defAttribute = getResourceOrNull(graph, URIs.defAttribute);
        explorer = getResourceOrNull(graph, URIs.explorer);
        gridCell = getResourceOrNull(graph, URIs.gridCell);
        gridComposite = getResourceOrNull(graph, URIs.gridComposite);
        label = getResourceOrNull(graph, URIs.label);
        sclTextEditor = getResourceOrNull(graph, URIs.sclTextEditor);
        scrolledComposite = getResourceOrNull(graph, URIs.scrolledComposite);
        trackedText = getResourceOrNull(graph, URIs.trackedText);
    }
    
    public static SWTResources getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SWTResources ret = session.peekService(SWTResources.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SWTResources(qc.getIndependentGraph(graph));
            session.registerService(SWTResources.class, ret);
        }
        return ret;
    }
    
    public static SWTResources getInstance(RequestProcessor session) throws DatabaseException {
        SWTResources ret = session.peekService(SWTResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SWTResources>() {
                public SWTResources perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SWTResources(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SWTResources.class, ret);
        }
        return ret;
    }
    
}

