package org.simantics.document.swt.core.widget;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.handler.EventHandler;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.WidgetContainer;

public class ButtonWidget extends LeafWidgetManager<Button> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Button control, JSONObject object) {

		if(control.isDisposed()) return;
		
		String text = object.getJSONField("text");
		
		control.setText(text);
		
		document.layout();
		
	}
    
	@Override
	protected Button doCreateControl(final SWTDocument document, Composite parent, final JSONObject object) {

		final Button label = new Button(parent, SWT.NONE);
		
//		final EventHandler onPress = object.getJSONField("onPress");
//		label.addSelectionListener(new );

		return label;
	}
	
    public static class ButtonCommandManager implements CommandManager<SWTDocument, WidgetContainer<Button>> {

        @Override
        public Collection<Object> updateCommandListeners(final SWTDocument document, final JSONObject object,
                WidgetContainer<Button> container) {
            
            List<Command> commands = object.getJSONField("commands");
            HashSet<Object> listeners = new HashSet<Object>();
            LinkedHashMap<WidgetData, String> data = new LinkedHashMap<WidgetData, String>();
            if(commands != null) {
	            for(Command c : commands) {
	                if(c.getCommand() == null || c.getTargetId() == null || c.getTrigger() == null)
	                    continue;
	                String trigger = c.getTrigger();
	                if("click".equals(trigger)) {
	                    WidgetData wd = document.getWidgetData().get(c.getTargetId());
	                    if(wd != null)
	                        data.put(wd, c.getCommand());
	                }
	            }
            }
            data.put(document.getWidgetData().get(object.getId()), "onPress");
            SelectionListener listener = new ButtonSelectionListener(data);
            Button button = container.getControl();
            if(!button.isDisposed()) {
            	button.addSelectionListener(listener);
                listeners.add(listener);
            }
            
            return listeners;
            
        }

        @Override
        public void removeListener(WidgetContainer<Button> container, Object listener) {
        	if(container.getControl().isDisposed()) return;
            if(listener instanceof SelectionListener)
                container.getControl().removeSelectionListener((SelectionListener) listener);
        }

    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, WidgetContainer widget, String command) {
        if("onPress".equals(command)) {
            AbstractEventHandler onPress = object.getJSONField("onPress");
            Map<String, String> data = Collections.emptyMap();
            return new PostEventCommand(document, onPress, data);
        }
        return null;
    }	
	
}
