package org.simantics.document.swt.core.base;


import java.util.TreeMap;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;

public abstract class HasWidgetsWidgetManager<W extends Composite> extends PropertyWidgetManager<WidgetContainer> {
	
	class Container extends WidgetContainer {
		
		@SuppressWarnings("unchecked")
		@Override
		protected void doUpdateProperties(SWTDocument document, Control control, JSONObject object) {
			HasWidgetsWidgetManager.this.doUpdateProperties(document, (W)control, object);
		}
		
		@Override
		protected Control doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
			if(parent.isDisposed()) {
				new Exception().printStackTrace();
				return null;
			}
			return HasWidgetsWidgetManager.this.doCreateControl(document, parent, object);
		}
		
	}	
	
	@Override
	public WidgetContainer createWidget(JSONObject object) {
		return new Container();
	}	
	
	@SuppressWarnings("unchecked")
	@Override
	public void updateChildren(SWTDocument document, JSONObject object, WidgetContainer widget, TreeMap<String, WidgetData> childMap) {
		
		for(WidgetData c : childMap.values()) {
			WidgetContainer con = (WidgetContainer)c.widget;
			con.getOrCreateControl(document, c.object);
		}
			
	}
	
	@Override
	public void updateProperties(SWTDocument document, JSONObject object, WidgetContainer widget) {
		widget.updateProperties(document, object);
	}
	
	abstract protected void doUpdateProperties(SWTDocument document, W control, JSONObject object);
	abstract protected W doCreateControl(SWTDocument document, Composite parent, JSONObject object);
	
}
